/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

public final class ThreadGroupBuilder {
    private String name;
    private Boolean isDaemon;
    private ThreadGroup parent;
    private Integer maxPriority;

    ThreadGroupBuilder() {
    }

    public ThreadGroupBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public ThreadGroupBuilder withDaemonFlag(boolean isDaemon) {
        this.isDaemon = isDaemon;
        return this;
    }

    public ThreadGroupBuilder withDefaultDaemonFlag() {
        this.isDaemon = null;
        return this;
    }

    public ThreadGroupBuilder withMaxPriority(int maxPriority) {
        if (maxPriority < 1 || maxPriority > 10) {
            throw new IllegalArgumentException(String.format("ThreadGroup max priority (%d) must be within [%d..%d]", maxPriority, 1, 10));
        }
        this.maxPriority = maxPriority;
        return this;
    }

    public ThreadGroupBuilder withDefaultMaxPriority() {
        this.maxPriority = null;
        return this;
    }

    public ThreadGroupBuilder withParent(ThreadGroup parent) {
        this.parent = parent;
        return this;
    }

    public ThreadGroup build() {
        ThreadGroup g = new ThreadGroup(this.parent == null ? Thread.currentThread().getThreadGroup() : this.parent, this.name);
        if (null != this.isDaemon && g.isDaemon() != this.isDaemon.booleanValue()) {
            g.setDaemon(this.isDaemon);
        }
        if (null != this.maxPriority && g.getMaxPriority() != this.maxPriority.intValue()) {
            g.setMaxPriority(this.maxPriority);
        }
        return g;
    }
}

