/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.tascalate.concurrent.CompletableFutureWrapper;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.ThreadFactoryBuilder;

class Timeouts {
    static final Duration NEGATIVE_DURATION = Duration.ofNanos(-1L);
    private static final Duration MAX_BY_NANOS = Duration.ofNanos(Long.MAX_VALUE);
    private static final Duration MAX_BY_MILLIS = Duration.ofMillis(Long.MAX_VALUE);
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, ((ThreadFactoryBuilder)((ThreadFactoryBuilder)new ThreadFactoryBuilder().withDaemonFlag(true)).withNameFormat(Timeouts.class.getName() + "-workers-%1$d")).build());

    private Timeouts() {
    }

    static Promise<Duration> delay(Duration duration) {
        TimeMeasurment tm = new TimeMeasurment(duration);
        CompletableFutureWrapper result = new CompletableFutureWrapper();
        ScheduledFuture<Boolean> timeout = scheduler.schedule(() -> result.success(duration), tm.amount, tm.unit);
        return result.onCancel(() -> timeout.cancel(true));
    }

    static <T> Promise<T> delayed(T value, Duration duration) {
        return Timeouts.delay(duration).dependent().thenApply(d -> value, true);
    }

    static <T> Promise<T> failAfter(Duration duration) {
        TimeMeasurment tm = new TimeMeasurment(duration);
        CompletableFutureWrapper result = new CompletableFutureWrapper();
        ScheduledFuture<Boolean> timeout = scheduler.schedule(() -> result.failure(new TimeoutException("Timeout after " + duration)), tm.amount, tm.unit);
        return result.onCancel(() -> timeout.cancel(true));
    }

    static Duration toDuration(long delay, TimeUnit timeUnit) {
        return Duration.of(delay, Timeouts.toChronoUnit(timeUnit));
    }

    private static ChronoUnit toChronoUnit(TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        switch (unit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("Unknown TimeUnit constant");
    }

    static class TimeMeasurment {
        final TimeUnit unit;
        final long amount;

        TimeMeasurment(Duration duration) {
            if (duration.compareTo(MAX_BY_NANOS) < 0) {
                this.amount = duration.toNanos();
                this.unit = TimeUnit.NANOSECONDS;
            } else if (duration.compareTo(MAX_BY_MILLIS) < 0) {
                this.amount = duration.toMillis();
                this.unit = TimeUnit.MILLISECONDS;
            } else {
                this.amount = duration.getSeconds();
                this.unit = TimeUnit.SECONDS;
            }
        }
    }
}

