/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.Promises;
import net.tascalate.concurrent.SharedFunctions;

abstract class Try<R> {
    private static final Try<Object> NOTHING = Try.success(null);

    Try() {
    }

    abstract R done();

    abstract boolean isSuccess();

    abstract boolean isCancel();

    abstract Promise<R> asPromise();

    static <R> Try<R> success(R result) {
        return new Success<R>(result);
    }

    static <R> Try<R> failure(Throwable error) {
        return new Failure(error);
    }

    static <R> Try<R> handle(R result, Throwable error, Promise<?> timeout) {
        if (null != timeout) {
            timeout.cancel(true);
        }
        return null == error ? Try.success(result) : Try.failure(error);
    }

    static <T> Try<T> doneOrTimeout(Try<T> result, Duration duration) {
        return null != result ? result : Try.failure(new TimeoutException("Timeout after " + duration));
    }

    static <R> Supplier<Try<R>> call(Supplier<? extends R> supplier) {
        return () -> {
            try {
                return Try.success(supplier.get());
            }
            catch (Throwable ex) {
                return Try.failure(ex);
            }
        };
    }

    static <R> Try<R> nothing() {
        return NOTHING;
    }

    static final class Failure<R>
    extends Try<R> {
        private final Throwable error;

        Failure(Throwable error) {
            this.error = error;
        }

        @Override
        R done() {
            if (this.error instanceof Error) {
                throw (Error)this.error;
            }
            if (this.error instanceof CancellationException) {
                throw (CancellationException)this.error;
            }
            throw SharedFunctions.wrapCompletionException(this.error);
        }

        @Override
        Promise<R> asPromise() {
            return Promises.failure(this.error);
        }

        @Override
        boolean isSuccess() {
            return false;
        }

        @Override
        boolean isCancel() {
            Throwable ex = SharedFunctions.unwrapCompletionException(this.error);
            return ex instanceof CancellationException;
        }
    }

    static final class Success<R>
    extends Try<R> {
        private final R result;

        Success(R result) {
            this.result = result;
        }

        @Override
        R done() {
            return this.result;
        }

        @Override
        Promise<R> asPromise() {
            return Promises.success(this.result);
        }

        @Override
        boolean isSuccess() {
            return true;
        }

        @Override
        boolean isCancel() {
            return false;
        }
    }
}

