/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.core;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

final class Cache<K, V> {
    private final Map<Reference<K>, V> entries = new ConcurrentHashMap<Reference<K>, V>();
    private final ReferenceQueue<K> queue = new ReferenceQueue();

    Cache() {
    }

    V get(K key, Function<? super K, ? extends V> valueFactory) {
        this.expungeStaleEntries();
        return (V)this.entries.computeIfAbsent(new KeyReference<K>(key), __ -> valueFactory.apply((Object)key));
    }

    private void expungeStaleEntries() {
        Reference<K> ref;
        while ((ref = this.queue.poll()) != null) {
            Reference<K> keyRef = ref;
            this.entries.remove(keyRef);
        }
    }

    static final class KeyReference<K>
    extends WeakReference<K> {
        private final int referentHashCode;

        KeyReference(K key) {
            this(key, (ReferenceQueue<K>)null);
        }

        KeyReference(K key, ReferenceQueue<K> queue) {
            super(key, queue);
            this.referentHashCode = key == null ? 0 : key.hashCode();
        }

        public int hashCode() {
            return this.referentHashCode;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KeyReference)) {
                return false;
            }
            Object r1 = this.get();
            Object r2 = ((KeyReference)other).get();
            return null == r1 ? null == r2 : r1.equals(r2);
        }
    }
}

