/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.core;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Stream;
import net.tascalate.concurrent.core.Cache;

public final class CancelMethodsCache {
    private static final Cache<Class<?>, Cancellation> CANCEL_METHODS = new Cache();
    private static final Cancellation NO_CANCELATION = (p, b) -> {
        System.err.println("Cancellation is not supported for promise " + p);
        return false;
    };
    private static final Function<Class<?>, Cancellation> LOOKUP_CANCEL_METHOD = c -> {
        Stream<Function> options = Stream.of(CancelMethodsCache::cancelInterruptibleMethodOf, CancelMethodsCache::cancelMethodOf, CancelMethodsCache::completeExceptionallyMethodOf);
        return options.map(option -> Optional.ofNullable((ExceptionalCancellation)option.apply(c))).filter(Optional::isPresent).map(Optional::get).map(ExceptionalCancellation::unchecked).findFirst().orElse(NO_CANCELATION);
    };

    private CancelMethodsCache() {
    }

    public static Cancellation cancellationOf(Class<?> stageClass) {
        return CANCEL_METHODS.get(stageClass, LOOKUP_CANCEL_METHOD);
    }

    private static ExceptionalCancellation cancelInterruptibleMethodOf(Class<?> clazz) {
        try {
            Method m = CancelMethodsCache.firstUnreflectableMethod(clazz.getMethod("cancel", Boolean.TYPE));
            if (null == m) {
                return null;
            }
            MethodHandle mh = CancelMethodsCache.unreflect(m).asType(MethodType.methodType(Boolean.TYPE, CompletionStage.class, Boolean.TYPE));
            return (p, b) -> mh.invokeExact(p, b);
        }
        catch (ReflectiveOperationException | SecurityException ex) {
            return null;
        }
    }

    private static ExceptionalCancellation cancelMethodOf(Class<?> clazz) {
        try {
            Method m = CancelMethodsCache.firstUnreflectableMethod(clazz.getMethod("cancel", new Class[0]));
            if (null == m) {
                return null;
            }
            MethodHandle mh = CancelMethodsCache.unreflect(m).asType(MethodType.methodType(Boolean.TYPE, CompletionStage.class));
            return (p, b) -> mh.invokeExact(p);
        }
        catch (ReflectiveOperationException | SecurityException ex) {
            return null;
        }
    }

    private static ExceptionalCancellation completeExceptionallyMethodOf(Class<?> clazz) {
        try {
            Method m = CancelMethodsCache.firstUnreflectableMethod(clazz.getMethod("completeExceptionally", Throwable.class));
            if (null == m) {
                return null;
            }
            MethodHandle mh = CancelMethodsCache.unreflect(m).asType(MethodType.methodType(Boolean.TYPE, CompletionStage.class, CancellationException.class));
            return (p, b) -> mh.invokeExact(p, new CancellationException());
        }
        catch (ReflectiveOperationException | SecurityException ex) {
            return null;
        }
    }

    private static Method firstUnreflectableMethod(Method m) {
        return CancelMethodsCache.firstUnreflectableMethod(m.getDeclaringClass(), m, new HashSet());
    }

    private static Method firstUnreflectableMethod(Class<?> clazz, Method m, Set<Class<?>> visited) {
        if (visited.contains(clazz)) {
            return null;
        }
        visited.add(clazz);
        if ((clazz.getModifiers() & 1) != 0) {
            try {
                Method parent = clazz.getDeclaredMethod(m.getName(), m.getParameterTypes());
                if ((parent.getModifiers() & 1) != 0) {
                    return parent;
                }
                return null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return Stream.concat(Stream.of(clazz.getSuperclass()), Stream.of(clazz.getInterfaces())).filter(c -> c != null && !visited.contains(c)).map(superClazz -> CancelMethodsCache.firstUnreflectableMethod(superClazz, m, visited)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static MethodHandle unreflect(Method m) throws IllegalAccessException {
        return MethodHandles.publicLookup().unreflect(m);
    }

    @FunctionalInterface
    static interface ExceptionalCancellation {
        public boolean apply(CompletionStage<?> var1, boolean var2) throws Throwable;

        default public Cancellation unchecked() {
            return (a, b) -> {
                try {
                    return this.apply(a, b);
                }
                catch (Error | RuntimeException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface Cancellation {
        public boolean apply(CompletionStage<?> var1, boolean var2);
    }
}

