/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.decorators;

import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.tascalate.concurrent.DependentPromise;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.PromiseOrigin;
import net.tascalate.concurrent.decorators.CustomizableDependentPromiseDecorator;
import net.tascalate.concurrent.decorators.ExtendedPromiseDecorator;
import net.tascalate.concurrent.decorators.PromiseCustomizer;

public class CustomizablePromiseDecorator<T>
extends ExtendedPromiseDecorator<T> {
    private final PromiseCustomizer customizer;

    public CustomizablePromiseDecorator(Promise<T> delegate, PromiseCustomizer customizer) {
        super(delegate);
        this.customizer = customizer;
    }

    @Override
    protected Runnable wrapArgument(Runnable original, boolean async) {
        return this.customizer.wrapArgument(original, async);
    }

    @Override
    protected <U, R> Function<U, R> wrapArgument(Function<U, R> original, boolean async, boolean isCompose) {
        return this.customizer.wrapArgument(original, async, isCompose);
    }

    @Override
    protected <U> Consumer<U> wrapArgument(Consumer<U> original, boolean async) {
        return this.customizer.wrapArgument(original, async);
    }

    @Override
    protected <U> Supplier<U> wrapArgument(Supplier<U> original, boolean async) {
        return this.customizer.wrapArgument(original, async);
    }

    @Override
    protected <U, V, R> BiFunction<U, V, R> wrapArgument(BiFunction<U, V, R> original, boolean async) {
        return this.customizer.wrapArgument(original, async);
    }

    @Override
    protected <U, V> BiConsumer<U, V> wrapArgument(BiConsumer<U, V> original, boolean async) {
        return this.customizer.wrapArgument(original, async);
    }

    @Override
    protected <U> CompletionStage<U> wrapArgument(CompletionStage<U> original, boolean async) {
        return this.customizer.wrapArgument(original, async);
    }

    @Override
    protected Executor wrapArgument(Executor original) {
        return this.customizer.wrapArgument(original);
    }

    @Override
    protected <U> Promise<U> wrapResult(CompletionStage<U> original) {
        return new CustomizablePromiseDecorator<T>((Promise)original, this.customizer);
    }

    @Override
    public DependentPromise<T> dependent() {
        return new CustomizableDependentPromiseDecorator(((Promise)this.delegate).dependent(), this.customizer);
    }

    @Override
    public DependentPromise<T> dependent(Set<PromiseOrigin> defaultEnlistOptions) {
        return new CustomizableDependentPromiseDecorator(((Promise)this.delegate).dependent(defaultEnlistOptions), this.customizer);
    }
}

