/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.delays;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.function.LongBinaryOperator;

class DurationCalcs {
    private static final ChronoUnit[] TIME_DIMENSIONS = new ChronoUnit[]{ChronoUnit.NANOS, ChronoUnit.MICROS, ChronoUnit.MILLIS, ChronoUnit.SECONDS};
    private static final Duration MAX_BY_NANOS = Duration.ofNanos(Long.MAX_VALUE);
    private static final Duration MAX_BY_MILLIS = Duration.ofMillis(Long.MAX_VALUE);
    private static final Duration MAX_DURATION = Duration.ofSeconds(Long.MAX_VALUE).withNanos(999999999);

    private DurationCalcs() {
    }

    static Duration safeTransform(Duration duration, LongBinaryOperator isConversionSafe, LongBinaryOperator conversion) {
        int dimIdx;
        long amount;
        if (duration.compareTo(MAX_BY_NANOS) < 0) {
            amount = duration.toNanos();
            dimIdx = 0;
        } else if (duration.compareTo(MAX_BY_MILLIS) < 0) {
            amount = duration.toMillis();
            dimIdx = 2;
        } else {
            amount = duration.getSeconds();
            dimIdx = 3;
        }
        int count = TIME_DIMENSIONS.length;
        while (dimIdx < count) {
            if (DurationCalcs.toBoolean(isConversionSafe.applyAsLong(amount, dimIdx))) {
                amount = conversion.applyAsLong(amount, dimIdx);
                return Duration.of(amount, TIME_DIMENSIONS[dimIdx]);
            }
            amount /= 1000L;
            ++dimIdx;
        }
        return MAX_DURATION;
    }

    static long safeExtractAmount(Duration duration, int targetDimIdx) {
        int sourceDimIdx;
        long amount;
        if (duration.compareTo(MAX_BY_NANOS) < 0) {
            amount = duration.toNanos();
            sourceDimIdx = 0;
        } else if (duration.compareTo(MAX_BY_MILLIS) < 0) {
            amount = duration.toMillis();
            sourceDimIdx = 2;
        } else {
            amount = duration.getSeconds();
            sourceDimIdx = 3;
        }
        if (sourceDimIdx == targetDimIdx) {
            return amount;
        }
        double factor = Math.pow(1000.0, sourceDimIdx - targetDimIdx);
        if (9.223372036854776E18 / (double)amount > factor) {
            return (long)((double)amount * factor);
        }
        return Long.MAX_VALUE;
    }

    static long toBoolean(boolean v) {
        return v ? 1L : 0L;
    }

    private static boolean toBoolean(long v) {
        return v != 0L;
    }
}

