/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.delays;

import java.time.Duration;
import net.tascalate.concurrent.DelayPolicy;
import net.tascalate.concurrent.RetryContext;
import net.tascalate.concurrent.delays.DurationCalcs;

public class ExponentialDelayPolicy<T>
implements DelayPolicy<T> {
    private final Duration initialDelay;
    private final double multiplier;

    public ExponentialDelayPolicy(double multiplier) {
        this(1000L, multiplier);
    }

    public ExponentialDelayPolicy(long initialDelayMillis, double multiplier) {
        this(Duration.ofMillis(initialDelayMillis), multiplier);
    }

    public ExponentialDelayPolicy(Duration initialDelay, double multiplier) {
        if (!DelayPolicy.isValid(initialDelay)) {
            throw new IllegalArgumentException("Initial delay must be positive but was: " + initialDelay);
        }
        if (multiplier <= 0.0) {
            throw new IllegalArgumentException("Multiplier must be a positive number but was: " + multiplier);
        }
        this.initialDelay = initialDelay;
        this.multiplier = multiplier;
    }

    @Override
    public Duration delay(RetryContext<? extends T> context) {
        double factor = Math.pow(this.multiplier, context.getRetryCount());
        return DurationCalcs.safeTransform(this.initialDelay, (amount, dimIdx) -> DurationCalcs.toBoolean(9.223372036854776E18 / (double)Math.abs(amount) > Math.abs(factor)), (amount, dimIdx) -> (long)((double)amount * factor));
    }
}

