/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.delays;

import java.util.Random;
import net.tascalate.concurrent.DelayPolicy;
import net.tascalate.concurrent.delays.RandomDelayPolicy;

public class ProportionalRandomDelayPolicy<T>
extends RandomDelayPolicy<T> {
    public static final double DEFAULT_MULTIPLIER = 0.1;
    private final double multiplier;

    public ProportionalRandomDelayPolicy(DelayPolicy<? super T> target) {
        this(target, 0.1);
    }

    public ProportionalRandomDelayPolicy(DelayPolicy<? super T> target, Random random) {
        this(target, 0.1, random);
    }

    public ProportionalRandomDelayPolicy(DelayPolicy<? super T> target, double multiplier) {
        super(target);
        if (multiplier <= 0.0) {
            throw new IllegalArgumentException("Multiplier must be a positive number but was: " + multiplier);
        }
        this.multiplier = multiplier;
    }

    public ProportionalRandomDelayPolicy(DelayPolicy<? super T> target, double multiplier, Random random) {
        super(target, random);
        if (multiplier <= 0.0) {
            throw new IllegalArgumentException("Multiplier must be a positive number but was: " + multiplier);
        }
        this.multiplier = multiplier;
    }

    @Override
    long addRandomJitter(long amount, double randomizer, int dimIdx) {
        double randomMultiplier = (1.0 - 2.0 * randomizer) * this.multiplier;
        return Math.max(0L, (long)((double)amount * (1.0 + randomMultiplier)));
    }

    @Override
    boolean checkBounds(long amount, double randomizer, int dimIdx) {
        double randomMultiplier = (1.0 - 2.0 * randomizer) * this.multiplier;
        return 9.223372036854776E18 / (double)Math.abs(amount) > Math.abs(1.0 + randomMultiplier);
    }
}

