/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.delays;

import java.time.Duration;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import net.tascalate.concurrent.DelayPolicy;
import net.tascalate.concurrent.RetryContext;
import net.tascalate.concurrent.delays.DelayPolicyWrapper;
import net.tascalate.concurrent.delays.DurationCalcs;

public abstract class RandomDelayPolicy<T>
extends DelayPolicyWrapper<T> {
    private final Supplier<Random> randomSource;

    protected RandomDelayPolicy(DelayPolicy<? super T> target) {
        this(target, ThreadLocalRandom::current);
    }

    protected RandomDelayPolicy(DelayPolicy<? super T> target, Random randomSource) {
        this(target, () -> randomSource);
    }

    private RandomDelayPolicy(DelayPolicy<? super T> target, Supplier<Random> randomSource) {
        super(target);
        this.randomSource = randomSource;
    }

    @Override
    public Duration delay(RetryContext<? extends T> context) {
        double randomizer = this.random().nextDouble();
        return DurationCalcs.safeTransform(this.target.delay(context), (amount, dimIdx) -> DurationCalcs.toBoolean(this.checkBounds(amount, randomizer, (int)dimIdx)), (amount, dimIdx) -> this.addRandomJitter(amount, randomizer, (int)dimIdx));
    }

    abstract long addRandomJitter(long var1, double var3, int var5);

    abstract boolean checkBounds(long var1, double var3, int var5);

    protected Random random() {
        return this.randomSource.get();
    }
}

