/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.io.AsyncChannel;
import net.tascalate.concurrent.io.AsyncResult;

public class AbstractAsyncFileChannel<F extends AbstractAsyncFileChannel<F>>
extends AsynchronousFileChannel
implements AsyncChannel {
    private final AsynchronousFileChannel delegate;

    protected AbstractAsyncFileChannel(AsynchronousFileChannel delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public long size() throws IOException {
        return this.delegate.size();
    }

    public F truncate(long size) throws IOException {
        this.delegate.truncate(size);
        AbstractAsyncFileChannel self = this;
        return (F)self;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.delegate.force(metaData);
    }

    public Promise<FileLock> lock(boolean shared) {
        return this.doLock(0L, Long.MAX_VALUE, shared);
    }

    public Promise<FileLock> lock(long position, long size, boolean shared) {
        return this.doLock(position, size, shared);
    }

    public final <A> void lock(boolean shared, A attachment, CompletionHandler<FileLock, ? super A> handler) {
        this.lock(0L, Long.MAX_VALUE, shared, attachment, handler);
    }

    protected Promise<FileLock> doLock(long position, long size, boolean shared) {
        AsyncResult<FileLock> asyncResult = new AsyncResult<FileLock>();
        this.lock(position, size, shared, null, asyncResult.handler);
        return asyncResult;
    }

    @Override
    public <A> void lock(long position, long size, boolean shared, A attachment, final CompletionHandler<FileLock, ? super A> handler) {
        if (null == handler) {
            this.delegate.lock(position, size, shared, attachment, null);
            return;
        }
        this.delegate.lock(position, size, shared, attachment, new CompletionHandler<FileLock, A>(){

            @Override
            public void completed(FileLock result, A attachment) {
                handler.completed(AbstractAsyncFileChannel.this.upgradeLock(result), attachment);
            }

            @Override
            public void failed(Throwable ex, A attachment) {
                handler.failed(ex, attachment);
            }
        });
    }

    public FileLock tryLock(boolean shared) throws IOException {
        return this.tryLock(0L, Long.MAX_VALUE, shared);
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.upgradeLock(this.delegate.tryLock(position, size, shared));
    }

    @Override
    public <A> void read(ByteBuffer dst, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.delegate.read(dst, position, attachment, handler);
    }

    public Promise<Integer> read(ByteBuffer dst, long position) {
        AsyncResult<Integer> asyncResult = new AsyncResult<Integer>();
        this.read(dst, position, null, asyncResult.handler);
        return asyncResult;
    }

    @Override
    public <A> void write(ByteBuffer src, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.delegate.write(src, position, attachment, handler);
    }

    public Promise<Integer> write(ByteBuffer src, long position) {
        AsyncResult<Integer> asyncResult = new AsyncResult<Integer>();
        this.write(src, position, null, asyncResult.handler);
        return asyncResult;
    }

    protected FileLock upgradeLock(final FileLock delegate) {
        return new FileLock(this, delegate.position(), delegate.size(), delegate.isShared()){

            @Override
            public void release() throws IOException {
                delegate.release();
            }

            @Override
            public boolean isValid() {
                return delegate.isValid();
            }
        };
    }
}

