/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.io;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.NetworkChannel;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.Set;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.io.AsyncChannel;
import net.tascalate.concurrent.io.AsyncResult;

public abstract class AbstractAsyncServerSocketChannel<S extends AbstractAsyncServerSocketChannel<S, C>, C extends AsynchronousSocketChannel>
implements AsyncChannel,
NetworkChannel {
    private final AsynchronousServerSocketChannel delegate;

    protected AbstractAsyncServerSocketChannel(AsynchronousServerSocketChannel delegate) {
        this.delegate = delegate;
    }

    public AsynchronousChannelProvider provider() {
        return this.delegate.provider();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.delegate.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.delegate.supportedOptions();
    }

    public S bind(SocketAddress local) throws IOException {
        return this.bind(local, 0);
    }

    public S bind(SocketAddress local, int backlog) throws IOException {
        this.delegate.bind(local, backlog);
        return this.self();
    }

    public <T> S setOption(SocketOption<T> name, T value) throws IOException {
        this.delegate.setOption((SocketOption)name, (Object)value);
        return this.self();
    }

    public Promise<C> accept() {
        AsyncResult asyncResult = new AsyncResult();
        this.accept(null, asyncResult.handler);
        return asyncResult;
    }

    public <A> void accept(A attachment, final CompletionHandler<? super C, ? super A> handler) {
        if (null == handler) {
            this.delegate.accept(attachment, null);
            return;
        }
        this.delegate.accept(attachment, new CompletionHandler<AsynchronousSocketChannel, A>(){

            @Override
            public void completed(AsynchronousSocketChannel result, A attachment) {
                handler.completed(AbstractAsyncServerSocketChannel.this.wrap(result), attachment);
            }

            @Override
            public void failed(Throwable exc, A attachment) {
                handler.failed(exc, attachment);
            }
        });
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.delegate.getLocalAddress();
    }

    protected abstract C wrap(AsynchronousSocketChannel var1);

    private S self() {
        return (S)this;
    }
}

