/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.io;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.io.AsyncByteChannel;
import net.tascalate.concurrent.io.AsyncResult;

public class AbstractAsyncSocketChannel<C extends AbstractAsyncSocketChannel<C>>
extends AsynchronousSocketChannel
implements AsyncByteChannel {
    private final AsynchronousSocketChannel delegate;

    protected AbstractAsyncSocketChannel(AsynchronousSocketChannel delegate) {
        super(delegate.provider());
        this.delegate = delegate;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.delegate.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.delegate.supportedOptions();
    }

    public C bind(SocketAddress local) throws IOException {
        this.delegate.bind(local);
        return this.self();
    }

    public <T> C setOption(SocketOption<T> name, T value) throws IOException {
        this.delegate.setOption((SocketOption)name, (Object)value);
        return this.self();
    }

    public C shutdownInput() throws IOException {
        this.delegate.shutdownInput();
        return this.self();
    }

    public C shutdownOutput() throws IOException {
        this.delegate.shutdownOutput();
        return this.self();
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.delegate.getRemoteAddress();
    }

    @Override
    public <A> void connect(SocketAddress remote, A attachment, CompletionHandler<Void, ? super A> handler) {
        this.delegate.connect(remote, attachment, handler);
    }

    public Promise<Void> connect(SocketAddress remote) {
        AsyncResult<Void> asyncResult = new AsyncResult<Void>();
        this.connect(remote, null, asyncResult.handler);
        return asyncResult;
    }

    @Override
    public Promise<Integer> read(ByteBuffer dst) {
        AsyncResult<Integer> asyncResult = new AsyncResult<Integer>();
        this.read(dst, null, asyncResult.handler);
        return asyncResult;
    }

    @Override
    public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.delegate.read(dst, timeout, unit, attachment, handler);
    }

    @Override
    public <A> void read(ByteBuffer[] dsts, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        this.delegate.read(dsts, offset, length, timeout, unit, attachment, handler);
    }

    @Override
    public Promise<Integer> write(ByteBuffer src) {
        AsyncResult<Integer> asyncResult = new AsyncResult<Integer>();
        this.write(src, null, asyncResult.handler);
        return asyncResult;
    }

    @Override
    public <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.delegate.write(src, timeout, unit, attachment, handler);
    }

    @Override
    public <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        this.delegate.write(srcs, offset, length, timeout, unit, attachment, handler);
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.delegate.getLocalAddress();
    }

    private C self() {
        return (C)this;
    }
}

