/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.io;

import java.io.IOException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import net.tascalate.concurrent.io.AbstractAsyncFileChannel;

public class AsyncFileChannel
extends AbstractAsyncFileChannel<AsyncFileChannel> {
    private static final FileAttribute<?>[] NO_ATTRIBUTES = new FileAttribute[0];

    protected AsyncFileChannel(AsynchronousFileChannel delegate) {
        super(delegate);
    }

    public static AsyncFileChannel open(Path file, ExecutorService executor, OpenOption ... options) throws IOException {
        Set set;
        if (options.length == 0) {
            set = Collections.emptySet();
        } else {
            set = new HashSet();
            Collections.addAll(set, options);
        }
        return AsyncFileChannel.open(file, executor, set, NO_ATTRIBUTES);
    }

    public static AsyncFileChannel open(Path file, ExecutorService executor, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Objects.requireNonNull(executor, "Executor should be specified");
        return new AsyncFileChannel(AsynchronousFileChannel.open(file, options, executor, attrs));
    }
}

