/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.io;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.tascalate.concurrent.DependentPromise;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.decorators.CustomizableDependentPromiseDecorator;
import net.tascalate.concurrent.decorators.CustomizablePromiseDecorator;
import net.tascalate.concurrent.decorators.PromiseCustomizer;
import net.tascalate.concurrent.io.BlockingThreadSelector;
import net.tascalate.concurrent.io.InterruptiblePromiseCustomizer;

public final class BlockingIO {
    private static final ThreadLocal<Interruptible> CURRENT = new ThreadLocal();
    private static final PromiseCustomizer INTERRUPTIBLE_PROMISE_CUSTOMIZER = new InterruptiblePromiseCustomizer();

    public static <T extends AutoCloseable> T register(T closeOnInterruption) {
        Interruptible current = CURRENT.get();
        if (null == current) {
            throw new IllegalStateException("Interruptible closeables may be registered only within interruptible blocks");
        }
        current.enlist(closeOnInterruption);
        return closeOnInterruption;
    }

    public static Runnable interruptible(Runnable action) {
        Interruptible current = new Interruptible();
        return () -> {
            Interruptible previous = current.enter();
            try {
                action.run();
            }
            finally {
                current.exit(previous);
            }
        };
    }

    public static <V> Callable<V> interruptibleCall(Callable<V> action) {
        Interruptible current = new Interruptible();
        return () -> {
            Interruptible previous = current.enter();
            try {
                Object v = action.call();
                return v;
            }
            finally {
                current.exit(previous);
            }
        };
    }

    public static <T> Supplier<T> interruptible(Supplier<T> action) {
        Interruptible current = new Interruptible();
        return () -> {
            Interruptible previous = current.enter();
            try {
                Object t = action.get();
                return t;
            }
            finally {
                current.exit(previous);
            }
        };
    }

    public static <T> Consumer<T> interruptible(Consumer<T> action) {
        Interruptible current = new Interruptible();
        return v -> {
            Interruptible previous = current.enter();
            try {
                action.accept(v);
            }
            finally {
                current.exit(previous);
            }
        };
    }

    public static <T, U> BiConsumer<T, U> interruptible(BiConsumer<T, U> action) {
        Interruptible current = new Interruptible();
        return (t, u) -> {
            Interruptible previous = current.enter();
            try {
                action.accept(t, u);
            }
            finally {
                current.exit(previous);
            }
        };
    }

    public static <T, R> Function<T, R> interruptible(Function<T, R> action) {
        Interruptible current = new Interruptible();
        return v -> {
            Interruptible previous = current.enter();
            try {
                Object r = action.apply(v);
                return r;
            }
            finally {
                current.exit(previous);
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> interruptible(BiFunction<T, U, R> action) {
        Interruptible current = new Interruptible();
        return (t, u) -> {
            Interruptible previous = current.enter();
            try {
                Object r = action.apply(t, u);
                return r;
            }
            finally {
                current.exit(previous);
            }
        };
    }

    public static <T> Predicate<T> interruptible(Predicate<T> action) {
        Interruptible current = new Interruptible();
        return v -> {
            Interruptible previous = current.enter();
            try {
                boolean bl = action.test(v);
                return bl;
            }
            finally {
                current.exit(previous);
            }
        };
    }

    public static <T, U> BiPredicate<T, U> interruptible(BiPredicate<T, U> action) {
        Interruptible current = new Interruptible();
        return (t, u) -> {
            Interruptible previous = current.enter();
            try {
                boolean bl = action.test(t, u);
                return bl;
            }
            finally {
                current.exit(previous);
            }
        };
    }

    public static <T> Function<Promise<T>, Promise<T>> interruptiblePromises() {
        return p -> p instanceof DependentPromise ? new CustomizableDependentPromiseDecorator((DependentPromise)p, INTERRUPTIBLE_PROMISE_CUSTOMIZER) : new CustomizablePromiseDecorator(p, INTERRUPTIBLE_PROMISE_CUSTOMIZER);
    }

    public <T> Function<DependentPromise<T>, DependentPromise<T>> interruptiblePromises\u02b9() {
        return p -> new CustomizableDependentPromiseDecorator(p, INTERRUPTIBLE_PROMISE_CUSTOMIZER);
    }

    static final class Interruptible {
        private final List<AutoCloseable> closeables = new CopyOnWriteArrayList<AutoCloseable>();
        private final BlockingThreadSelector selector = new BlockingThreadSelector(this::interrupted);

        Interruptible() {
        }

        final Interruptible enter() {
            Interruptible previous = (Interruptible)CURRENT.get();
            CURRENT.set(this);
            this.selector.enter();
            return previous;
        }

        final void exit(Interruptible previous) {
            this.selector.exit();
            this.closeables.clear();
            if (null != previous) {
                CURRENT.set(previous);
            } else {
                CURRENT.remove();
            }
        }

        void interrupted() {
            for (AutoCloseable closeable : this.closeables) {
                Interruptible.close(closeable);
            }
            this.closeables.clear();
        }

        void enlist(AutoCloseable closeOnInterruption) {
            this.closeables.add(closeOnInterruption);
            if (Thread.currentThread().isInterrupted()) {
                Interruptible.close(closeOnInterruption);
            }
        }

        private static void close(AutoCloseable closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

