/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.locks;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.LongBinaryOperator;
import net.tascalate.concurrent.CompletableFutureWrapper;

public class AsyncCountDownLatch
extends CompletableFutureWrapper<Long> {
    private static final AtomicLongFieldUpdater<AsyncCountDownLatch> COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(AsyncCountDownLatch.class, "count");
    private static final LongBinaryOperator DECREMENT = (prev, change) -> Math.max(0L, prev - change);
    private final long initial;
    private volatile long count;

    public AsyncCountDownLatch(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("count < 0 : " + count);
        }
        this.count = this.initial = count;
        if (count == 0L) {
            this.success(count);
        }
    }

    public long countDown() {
        return this.countDown(1L);
    }

    public long countDown(long delta) {
        if (delta <= 0L) {
            throw new IllegalArgumentException("delta <= 0 : " + delta);
        }
        long current = COUNT_UPDATER.getAndAccumulate(this, delta, DECREMENT);
        if (current == 0L) {
            this.success(this.initial);
        }
        return current;
    }
}

