/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.locks;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.tascalate.concurrent.CompletableFutureWrapper;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.Promises;

abstract class AsyncSemaphoreBase<T> {
    private final long totalPermits;
    private final boolean fair;
    private final AtomicLong availablePermits;
    private final Queue<AbstractSemaphorePromise> waiters;

    AsyncSemaphoreBase(long totalPermits, boolean fair) {
        if (totalPermits <= 0L) {
            throw new IllegalArgumentException("totalPermits must be a positive integer");
        }
        this.totalPermits = totalPermits;
        this.fair = fair;
        this.availablePermits = new AtomicLong(totalPermits);
        this.waiters = new ConcurrentLinkedQueue<AbstractSemaphorePromise>();
    }

    public long availablePermits() {
        return this.availablePermits.get();
    }

    public int getQueueLength() {
        return this.waiters.size();
    }

    long drainPermitsInternal() {
        if (this.fair) {
            // empty if block
        }
        long acquired = this.availablePermits.getAndSet(0L);
        return acquired;
    }

    boolean tryAcquireInternal(long permits) {
        if (permits <= 0L || permits > this.totalPermits) {
            throw new IllegalArgumentException(String.format("Requested number of permits %d is not within range 1..%d", permits, this.totalPermits));
        }
        if (this.fair && null != this.waiters.peek()) {
            return false;
        }
        boolean[] altered = new boolean[]{false};
        this.availablePermits.accumulateAndGet(permits, (current, delta) -> {
            if (current >= delta) {
                altered[0] = true;
                return current - delta;
            }
            altered[0] = false;
            return current;
        });
        return altered[0];
    }

    public Promise<T> acquire(long permits) {
        if (this.tryAcquireInternal(permits)) {
            return Promises.success(this.createPromisePayload(permits));
        }
        AbstractSemaphorePromise promise = this.createPromise(permits);
        this.waiters.add(promise);
        this.nextWaiters();
        return promise;
    }

    void release(long permits) {
        long current = this.availablePermits.addAndGet(permits);
        if (current < 0L || current > this.totalPermits) {
            throw new IllegalStateException(String.format("After releasing %d permits number of available permits %d is not within range 1..%d", permits, current, this.totalPermits));
        }
        this.nextWaiters();
    }

    protected abstract T createPromisePayload(long var1);

    protected abstract AbstractSemaphorePromise createPromise(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextWaiters() {
        AbstractSemaphorePromise head = null;
        while (null != (head = this.waiters.peek()) && head.lock()) {
            try {
                if (head.isDone()) {
                    this.waiters.remove(head);
                } else {
                    long oldPermits = this.availablePermits.get();
                    long newPermits = oldPermits - head.permits();
                    if (newPermits < 0L) break;
                    if (this.availablePermits.compareAndSet(oldPermits, newPermits)) {
                        if (head.acquire()) {
                            AbstractSemaphorePromise found = this.waiters.poll();
                            if (found != head) {
                                throw new IllegalStateException("The acquired semaphore promise is not equal to the top of the queue");
                            }
                        } else {
                            this.waiters.remove(head);
                            this.availablePermits.addAndGet(head.permits());
                        }
                    }
                }
            }
            finally {
                head.unlock();
            }
            if (head != null) continue;
        }
    }

    public String toString() {
        return String.format("%s(totalPermits=%d, fair=%s, availablePermits=%d, queueSize=%d)", this.getClass().getSimpleName(), this.totalPermits, this.fair, this.availablePermits.get(), this.waiters.size());
    }

    protected abstract class AbstractSemaphorePromise
    extends CompletableFutureWrapper<T> {
        private final AtomicBoolean locked = new AtomicBoolean();

        protected AbstractSemaphorePromise() {
        }

        boolean lock() {
            return this.locked.compareAndSet(false, true);
        }

        boolean unlock() {
            return this.locked.compareAndSet(true, false);
        }

        abstract long permits();

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (super.cancel(mayInterruptIfRunning)) {
                AsyncSemaphoreBase.this.waiters.remove(this);
                return true;
            }
            return false;
        }

        abstract boolean acquire();
    }
}

