/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.locks;

import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.tascalate.concurrent.CompletableFutureWrapper;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.locks.AsyncLock;

public class DefaultAsyncLock
implements AsyncLock {
    final Queue<LockPromise> waiters = new ConcurrentLinkedQueue<LockPromise>();

    @Override
    public Optional<AsyncLock.Token> tryAcquire() {
        Promise<AsyncLock.Token> lock = this.acquire();
        if (lock.isDone()) {
            return Optional.of(lock.join());
        }
        this.waiters.remove(lock);
        return Optional.empty();
    }

    @Override
    public Promise<AsyncLock.Token> acquire() {
        LockPromise promise = new LockPromise();
        this.waiters.add(promise);
        this.nextWaiter();
        return promise;
    }

    private void nextWaiter() {
        LockPromise head = this.waiters.peek();
        if (head != null) {
            head.acquire();
        }
    }

    public String toString() {
        LockPromise head = this.waiters.peek();
        boolean isAcquired = head != null & head.isDone();
        int size = Math.max(0, this.waiters.size() - (isAcquired ? 1 : 0));
        return String.format("%s(acquired=%s, queueSize=%d)", this.getClass().getSimpleName(), isAcquired, size);
    }

    private class LockPromise
    extends CompletableFutureWrapper<AsyncLock.Token> {
        private final AtomicBoolean released = new AtomicBoolean();
        private final AsyncLock.Token token = this::release;

        private LockPromise() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (super.cancel(mayInterruptIfRunning)) {
                DefaultAsyncLock.this.waiters.remove(this);
                return true;
            }
            return false;
        }

        boolean acquire() {
            return this.success(this.token);
        }

        void release() {
            if (this.released.compareAndSet(false, true)) {
                LockPromise released = DefaultAsyncLock.this.waiters.poll();
                if (this != released) {
                    throw new IllegalStateException("The released lock is not equal to the top of the queue");
                }
                DefaultAsyncLock.this.nextWaiter();
            }
        }
    }
}

