/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.locks;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.tascalate.concurrent.locks.AsyncSemaphoreBase;
import net.tascalate.concurrent.locks.AsyncSemaphoreLock;

public class DefaultAsyncSemaphoreLock
extends AsyncSemaphoreBase<AsyncSemaphoreLock.Token>
implements AsyncSemaphoreLock {
    public DefaultAsyncSemaphoreLock(long totalPermits, boolean fair) {
        super(totalPermits, fair);
    }

    @Override
    public Optional<AsyncSemaphoreLock.Token> drainPermits() {
        long acquired = this.drainPermitsInternal();
        return acquired > 0L ? Optional.of(this.createPromisePayload(acquired)) : Optional.empty();
    }

    @Override
    public Optional<AsyncSemaphoreLock.Token> tryAcquire(long permitsCount) {
        if (this.tryAcquireInternal(permitsCount)) {
            return Optional.of(this.createPromisePayload(permitsCount));
        }
        return Optional.empty();
    }

    @Override
    protected AsyncSemaphoreLock.Token createPromisePayload(long permits) {
        return new AbstractToken(permits){
            private final AtomicBoolean released;
            {
                this.released = new AtomicBoolean();
            }

            @Override
            public void release() {
                if (this.released.compareAndSet(false, true)) {
                    DefaultAsyncSemaphoreLock.this.release(this.permits());
                }
            }
        };
    }

    @Override
    protected LockPromise createPromise(long permitsCount) {
        return new LockPromise(permitsCount);
    }

    private class LockPromise
    extends AsyncSemaphoreBase.AbstractSemaphorePromise {
        private final AtomicBoolean released = new AtomicBoolean();
        private final AsyncSemaphoreLock.Token token;

        LockPromise(long permitsCount) {
            this.token = new AbstractToken(permitsCount){

                @Override
                public void release() {
                    LockPromise.this.release();
                }
            };
        }

        @Override
        long permits() {
            return this.token.permits();
        }

        @Override
        boolean acquire() {
            return this.success(this.token);
        }

        void release() {
            if (this.released.compareAndSet(false, true)) {
                DefaultAsyncSemaphoreLock.this.release(this.permits());
            }
        }
    }

    static abstract class AbstractToken
    implements AsyncSemaphoreLock.Token {
        private final long permitsCount;

        public AbstractToken(long permitsCount) {
            this.permitsCount = permitsCount;
        }

        @Override
        public long permits() {
            return this.permitsCount;
        }
    }
}

