/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.var;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.tascalate.concurrent.DependentPromise;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.TaskExecutorService;
import net.tascalate.concurrent.decorators.CustomizableDependentPromiseDecorator;
import net.tascalate.concurrent.decorators.CustomizablePromiseDecorator;
import net.tascalate.concurrent.var.ContextVar;
import net.tascalate.concurrent.var.ContextualExecutor;
import net.tascalate.concurrent.var.ContextualExecutorService;
import net.tascalate.concurrent.var.ContextualPromiseCustomizer;
import net.tascalate.concurrent.var.ContextualScheduledExecutorService;
import net.tascalate.concurrent.var.ContextualTaskExecutorService;
import net.tascalate.concurrent.var.Contextualization;

public class ContextTrampoline {
    private final List<ContextVar<?>> contextVars;
    private static final AtomicLong COUNTER = new AtomicLong();
    private static final ContextTrampoline NOP = new ContextTrampoline(null){

        @Override
        public Runnable contextual(Runnable action) {
            return action;
        }

        @Override
        public Runnable contextual(Propagation propagation, Runnable action) {
            return action;
        }

        @Override
        public <V> Callable<V> contextualCall(Callable<V> action) {
            return action;
        }

        @Override
        public <V> Callable<V> contextualCall(Propagation propagation, Callable<V> action) {
            return action;
        }

        @Override
        public <T> Supplier<T> contextual(Supplier<T> action) {
            return action;
        }

        @Override
        public <T> Supplier<T> contextual(Propagation propagation, Supplier<T> action) {
            return action;
        }

        @Override
        public <T> Consumer<T> contextual(Consumer<T> action) {
            return action;
        }

        @Override
        public <T> Consumer<T> contextual(Propagation propagation, Consumer<T> action) {
            return action;
        }

        @Override
        public <T, U> BiConsumer<T, U> contextual(BiConsumer<T, U> action) {
            return action;
        }

        @Override
        public <T, U> BiConsumer<T, U> contextual(Propagation propagation, BiConsumer<T, U> action) {
            return action;
        }

        @Override
        public <T, R> Function<T, R> contextual(Function<T, R> action) {
            return action;
        }

        @Override
        public <T, R> Function<T, R> contextual(Propagation propagation, Function<T, R> action) {
            return action;
        }

        @Override
        public <T, U, R> BiFunction<T, U, R> contextual(BiFunction<T, U, R> action) {
            return action;
        }

        @Override
        public <T, U, R> BiFunction<T, U, R> contextual(Propagation propagation, BiFunction<T, U, R> action) {
            return action;
        }

        @Override
        public <T> Predicate<T> contextual(Predicate<T> action) {
            return action;
        }

        @Override
        public <T> Predicate<T> contextual(Propagation propagation, Predicate<T> action) {
            return action;
        }

        @Override
        public <T, U> BiPredicate<T, U> contextual(BiPredicate<T, U> action) {
            return action;
        }

        @Override
        public <T, U> BiPredicate<T, U> contextual(Propagation propagation, BiPredicate<T, U> action) {
            return action;
        }

        @Override
        public <T> Function<Promise<T>, Promise<T>> boundPromises() {
            return Function.identity();
        }

        @Override
        public <T> Function<DependentPromise<T>, DependentPromise<T>> boundPromises\u02b9() {
            return Function.identity();
        }

        @Override
        public <T> Function<Promise<T>, Promise<T>> boundPromises(Propagation propagation) {
            return Function.identity();
        }

        @Override
        public <T> Function<DependentPromise<T>, DependentPromise<T>> boundPromises\u02b9(Propagation propagation) {
            return Function.identity();
        }

        @Override
        public Executor bind(Executor executor) {
            return executor;
        }

        @Override
        public Executor bind(Executor executor, Propagation propagation) {
            return executor;
        }

        @Override
        public ExecutorService bind(ExecutorService executorService) {
            return executorService;
        }

        @Override
        public ExecutorService bind(ExecutorService executorService, Propagation propagation) {
            return executorService;
        }

        @Override
        public TaskExecutorService bind(TaskExecutorService executorService) {
            return executorService;
        }

        @Override
        public TaskExecutorService bind(TaskExecutorService executorService, Propagation propagation) {
            return executorService;
        }

        @Override
        public ScheduledExecutorService bind(ScheduledExecutorService executorService) {
            return executorService;
        }

        @Override
        public ScheduledExecutorService bind(ScheduledExecutorService executorService, Propagation propagation) {
            return executorService;
        }
    };

    private ContextTrampoline(List<? extends ContextVar<?>> contextVars) {
        this.contextVars = contextVars == null ? Collections.emptyList() : Collections.unmodifiableList(contextVars);
    }

    private Contextualization captureContextualization(Propagation propagation) {
        return new Contextualization(this.contextVars, propagation, ContextTrampoline.captureContext(this.contextVars));
    }

    public Runnable contextual(Runnable action) {
        return this.contextual(Propagation.OPTIMIZED, action);
    }

    public Runnable contextual(Propagation propagation, Runnable action) {
        Contextualization ctxz = this.captureContextualization(propagation);
        return () -> {
            List<Object> capturedContext = ctxz.enter();
            try {
                action.run();
            }
            finally {
                ctxz.exit(capturedContext);
            }
        };
    }

    public <V> Callable<V> contextualCall(Callable<V> action) {
        return this.contextualCall(Propagation.OPTIMIZED, action);
    }

    public <V> Callable<V> contextualCall(Propagation propagation, Callable<V> action) {
        Contextualization ctxz = this.captureContextualization(propagation);
        return () -> {
            List<Object> capturedContext = ctxz.enter();
            try {
                Object v = action.call();
                return v;
            }
            finally {
                ctxz.exit(capturedContext);
            }
        };
    }

    public <T> Supplier<T> contextual(Supplier<T> action) {
        return this.contextual(Propagation.OPTIMIZED, action);
    }

    public <T> Supplier<T> contextual(Propagation propagation, Supplier<T> action) {
        Contextualization ctxz = this.captureContextualization(propagation);
        return () -> {
            List<Object> capturedContext = ctxz.enter();
            try {
                Object t = action.get();
                return t;
            }
            finally {
                ctxz.exit(capturedContext);
            }
        };
    }

    public <T> Consumer<T> contextual(Consumer<T> action) {
        return this.contextual(Propagation.OPTIMIZED, action);
    }

    public <T> Consumer<T> contextual(Propagation propagation, Consumer<T> action) {
        Contextualization ctxz = this.captureContextualization(propagation);
        return v -> {
            List<Object> capturedContext = ctxz.enter();
            try {
                action.accept(v);
            }
            finally {
                ctxz.exit(capturedContext);
            }
        };
    }

    public <T, U> BiConsumer<T, U> contextual(BiConsumer<T, U> action) {
        return this.contextual(Propagation.OPTIMIZED, action);
    }

    public <T, U> BiConsumer<T, U> contextual(Propagation propagation, BiConsumer<T, U> action) {
        Contextualization ctxz = this.captureContextualization(propagation);
        return (t, u) -> {
            List<Object> capturedContext = ctxz.enter();
            try {
                action.accept(t, u);
            }
            finally {
                ctxz.exit(capturedContext);
            }
        };
    }

    public <T, R> Function<T, R> contextual(Function<T, R> action) {
        return this.contextual(Propagation.OPTIMIZED, action);
    }

    public <T, R> Function<T, R> contextual(Propagation propagation, Function<T, R> action) {
        Contextualization ctxz = this.captureContextualization(propagation);
        return v -> {
            List<Object> capturedContext = ctxz.enter();
            try {
                Object r = action.apply(v);
                return r;
            }
            finally {
                ctxz.exit(capturedContext);
            }
        };
    }

    public <T, U, R> BiFunction<T, U, R> contextual(BiFunction<T, U, R> action) {
        return this.contextual(Propagation.OPTIMIZED, action);
    }

    public <T, U, R> BiFunction<T, U, R> contextual(Propagation propagation, BiFunction<T, U, R> action) {
        Contextualization ctxz = this.captureContextualization(propagation);
        return (t, u) -> {
            List<Object> capturedContext = ctxz.enter();
            try {
                Object r = action.apply(t, u);
                return r;
            }
            finally {
                ctxz.exit(capturedContext);
            }
        };
    }

    public <T> Predicate<T> contextual(Predicate<T> action) {
        return this.contextual(Propagation.OPTIMIZED, action);
    }

    public <T> Predicate<T> contextual(Propagation propagation, Predicate<T> action) {
        Contextualization ctxz = this.captureContextualization(propagation);
        return v -> {
            List<Object> capturedContext = ctxz.enter();
            try {
                boolean bl = action.test(v);
                return bl;
            }
            finally {
                ctxz.exit(capturedContext);
            }
        };
    }

    public <T, U> BiPredicate<T, U> contextual(BiPredicate<T, U> action) {
        return this.contextual(Propagation.OPTIMIZED, action);
    }

    public <T, U> BiPredicate<T, U> contextual(Propagation propagation, BiPredicate<T, U> action) {
        Contextualization ctxz = this.captureContextualization(propagation);
        return (t, u) -> {
            List<Object> capturedContext = ctxz.enter();
            try {
                boolean bl = action.test(t, u);
                return bl;
            }
            finally {
                ctxz.exit(capturedContext);
            }
        };
    }

    public <T> Function<Promise<T>, Promise<T>> boundPromises() {
        return this.boundPromises(Propagation.OPTIMIZED);
    }

    public <T> Function<DependentPromise<T>, DependentPromise<T>> boundPromises\u02b9() {
        return this.boundPromises\u02b9(Propagation.OPTIMIZED);
    }

    public <T> Function<Promise<T>, Promise<T>> boundPromises(Propagation propagation) {
        ContextualPromiseCustomizer customizer = new ContextualPromiseCustomizer(this.captureContextualization(propagation));
        return p -> p instanceof DependentPromise ? new CustomizableDependentPromiseDecorator((DependentPromise)p, customizer) : new CustomizablePromiseDecorator(p, customizer);
    }

    public <T> Function<DependentPromise<T>, DependentPromise<T>> boundPromises\u02b9(Propagation propagation) {
        ContextualPromiseCustomizer customizer = new ContextualPromiseCustomizer(this.captureContextualization(propagation));
        return p -> new CustomizableDependentPromiseDecorator(p, customizer);
    }

    public Executor bind(Executor executor) {
        return this.bind(executor, Propagation.OPTIMIZED);
    }

    public Executor bind(Executor executor, Propagation propagation) {
        return this.bindExecutor(executor, propagation, ContextualExecutor::new);
    }

    public ExecutorService bind(ExecutorService executorService) {
        return this.bind(executorService, Propagation.OPTIMIZED);
    }

    public ExecutorService bind(ExecutorService executorService, Propagation propagation) {
        return this.bindExecutor(executorService, propagation, ContextualExecutorService::new);
    }

    public TaskExecutorService bind(TaskExecutorService executorService) {
        return this.bind(executorService, Propagation.OPTIMIZED);
    }

    public TaskExecutorService bind(TaskExecutorService executorService, Propagation propagation) {
        return this.bindExecutor(executorService, propagation, ContextualTaskExecutorService::new);
    }

    public ScheduledExecutorService bind(ScheduledExecutorService executorService) {
        return this.bind(executorService, Propagation.OPTIMIZED);
    }

    public ScheduledExecutorService bind(ScheduledExecutorService executorService, Propagation propagation) {
        return this.bindExecutor(executorService, propagation, ContextualScheduledExecutorService::new);
    }

    public static ContextTrampoline relay(ContextVar<?> contextVar) {
        return new ContextTrampoline(Collections.singletonList(contextVar));
    }

    public static ContextTrampoline relay(ThreadLocal<?> threadLocal) {
        return ContextTrampoline.relay(ContextVar.from(threadLocal));
    }

    public static ContextTrampoline relay(ContextVar<?> ... contextVars) {
        return new ContextTrampoline(Arrays.asList(contextVars));
    }

    public static ContextTrampoline relay(ThreadLocal<?> ... threadLocals) {
        return new ContextTrampoline(Arrays.stream(threadLocals).map(ContextVar::from).collect(Collectors.toList()));
    }

    public static ContextTrampoline relay(List<? extends ContextVar<?>> contextVars) {
        if (null == contextVars || contextVars.isEmpty()) {
            return NOP;
        }
        return new ContextTrampoline(new ArrayList(contextVars));
    }

    public static ContextTrampoline relayThreadLocals(List<? extends ThreadLocal<?>> threadLocals) {
        if (null == threadLocals || threadLocals.isEmpty()) {
            return NOP;
        }
        return ContextTrampoline.relay(threadLocals.stream().map(tl -> ContextVar.from(tl)).collect(Collectors.toList()));
    }

    static List<Object> captureContext(List<? extends ContextVar<?>> contextVars) {
        return contextVars.stream().map(v -> v.get()).collect(Collectors.toList());
    }

    private <D extends Executor> D bindExecutor(D delegate, Propagation propagation, BiFunction<D, Contextualization, D> ctr) {
        return (D)((Executor)ctr.apply(delegate, this.captureContextualization(propagation)));
    }

    static String generateVarName() {
        return "<anonymous" + COUNTER.getAndIncrement() + ">";
    }

    public static enum Propagation {
        OPTIMIZED,
        STRICT;

    }
}

