/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.var;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.tascalate.concurrent.var.ContextTrampoline;

public interface ContextVar<T> {
    public T get();

    public void set(T var1);

    default public void remove() {
        this.set(null);
    }

    public static <T> ContextVar<T> define(Supplier<? extends T> reader, Consumer<? super T> writer) {
        return ContextVar.define(reader, writer, null);
    }

    public static <T> ContextVar<T> define(String name, Supplier<? extends T> reader, Consumer<? super T> writer) {
        return ContextVar.define(name, reader, writer, null);
    }

    public static <T> ContextVar<T> define(Supplier<? extends T> reader, Consumer<? super T> writer, Runnable eraser) {
        return ContextVar.define(ContextTrampoline.generateVarName(), reader, writer, eraser);
    }

    public static <T> ContextVar<T> define(final String name, final Supplier<? extends T> reader, final Consumer<? super T> writer, final Runnable eraser) {
        return new ContextVar<T>(){

            @Override
            public T get() {
                return reader.get();
            }

            @Override
            public void set(T value) {
                writer.accept(value);
            }

            @Override
            public void remove() {
                if (null != eraser) {
                    eraser.run();
                } else {
                    this.set(null);
                }
            }

            public String toString() {
                return String.format("<custom-ctx-var>[%s]", name);
            }
        };
    }

    public static <T> ContextVar<T> from(final ThreadLocal<T> tl) {
        return new ContextVar<T>(){

            @Override
            public T get() {
                return tl.get();
            }

            @Override
            public void set(T value) {
                tl.set(value);
            }

            @Override
            public void remove() {
                tl.remove();
            }

            public String toString() {
                return String.format("<thread-local-ctx-var>[%s]", tl);
            }
        };
    }
}

