/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.var;

import java.util.List;
import java.util.concurrent.Executor;
import net.tascalate.concurrent.var.Contextualization;

class ContextualExecutor<D extends Executor>
implements Executor {
    protected final D delegate;
    protected final Contextualization ctxz;

    ContextualExecutor(D delegate, Contextualization ctxz) {
        this.delegate = delegate;
        this.ctxz = ctxz;
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.contextualRunnable(command));
    }

    Runnable contextualRunnable(Runnable original) {
        return () -> {
            List<Object> originalContext = this.ctxz.enter();
            try {
                original.run();
            }
            finally {
                this.ctxz.exit(originalContext);
            }
        };
    }
}

