/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.var;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import net.tascalate.concurrent.var.ContextualExecutor;
import net.tascalate.concurrent.var.Contextualization;

class ContextualExecutorService<D extends ExecutorService>
extends ContextualExecutor<D>
implements ExecutorService {
    ContextualExecutorService(D delegate, Contextualization ctxz) {
        super(delegate, ctxz);
    }

    @Override
    public void shutdown() {
        ((ExecutorService)this.delegate).shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return ((ExecutorService)this.delegate).shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return ((ExecutorService)this.delegate).isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return ((ExecutorService)this.delegate).isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return ((ExecutorService)this.delegate).awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return ((ExecutorService)this.delegate).submit(this.contextualCallable(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return ((ExecutorService)this.delegate).submit(this.contextualRunnable(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return ((ExecutorService)this.delegate).submit(this.contextualRunnable(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return ((ExecutorService)this.delegate).invokeAll(this.contextualCallables(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return ((ExecutorService)this.delegate).invokeAll(this.contextualCallables(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return ((ExecutorService)this.delegate).invokeAny(this.contextualCallables(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return ((ExecutorService)this.delegate).invokeAny(this.contextualCallables(tasks), timeout, unit);
    }

    private <T> Collection<Callable<T>> contextualCallables(Collection<? extends Callable<T>> tasks) {
        return tasks.stream().map(this::contextualCallable).collect(Collectors.toList());
    }

    <T> Callable<T> contextualCallable(Callable<T> original) {
        return () -> {
            List<Object> originalContext = this.ctxz.enter();
            try {
                Object v = original.call();
                return v;
            }
            finally {
                this.ctxz.exit(originalContext);
            }
        };
    }
}

