/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.var;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.tascalate.concurrent.decorators.PromiseCustomizer;
import net.tascalate.concurrent.var.Contextualization;

class ContextualPromiseCustomizer
implements PromiseCustomizer {
    private final Contextualization ctxz;

    ContextualPromiseCustomizer(Contextualization ctxz) {
        this.ctxz = ctxz;
    }

    @Override
    public Runnable wrapArgument(Runnable original, boolean async) {
        return () -> {
            List<Object> originalContext = this.ctxz.enter();
            try {
                original.run();
            }
            finally {
                this.ctxz.exit(originalContext);
            }
        };
    }

    @Override
    public <U, R> Function<U, R> wrapArgument(Function<U, R> original, boolean async, boolean isCompose) {
        return u -> {
            List<Object> originalContext = this.ctxz.enter();
            try {
                Object r = original.apply(u);
                return r;
            }
            finally {
                this.ctxz.exit(originalContext);
            }
        };
    }

    @Override
    public <U> Consumer<U> wrapArgument(Consumer<U> original, boolean async) {
        return u -> {
            List<Object> originalContext = this.ctxz.enter();
            try {
                original.accept(u);
            }
            finally {
                this.ctxz.exit(originalContext);
            }
        };
    }

    @Override
    public <U> Supplier<U> wrapArgument(Supplier<U> original, boolean async) {
        return () -> {
            List<Object> originalContext = this.ctxz.enter();
            try {
                Object t = original.get();
                return t;
            }
            finally {
                this.ctxz.exit(originalContext);
            }
        };
    }

    @Override
    public <U> Predicate<U> wrapArgument(Predicate<U> original, boolean async) {
        return u -> {
            List<Object> originalContext = this.ctxz.enter();
            try {
                boolean bl = original.test(u);
                return bl;
            }
            finally {
                this.ctxz.exit(originalContext);
            }
        };
    }

    @Override
    public <U, V, R> BiFunction<U, V, R> wrapArgument(BiFunction<U, V, R> original, boolean async) {
        return (u, v) -> {
            List<Object> originalContext = this.ctxz.enter();
            try {
                Object r = original.apply(u, v);
                return r;
            }
            finally {
                this.ctxz.exit(originalContext);
            }
        };
    }

    @Override
    public <U, V> BiConsumer<U, V> wrapArgument(BiConsumer<U, V> original, boolean async) {
        return (u, v) -> {
            List<Object> originalContext = this.ctxz.enter();
            try {
                original.accept(u, v);
            }
            finally {
                this.ctxz.exit(originalContext);
            }
        };
    }
}

