/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.var;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.tascalate.concurrent.var.ContextTrampoline;
import net.tascalate.concurrent.var.ContextVar;

class Contextualization {
    private final List<ContextVar<?>> contextVars;
    private final ContextTrampoline.Propagation propagation;
    private final List<Object> capturedContext;

    Contextualization(List<ContextVar<?>> contextVars, ContextTrampoline.Propagation propagation, List<Object> capturedContext) {
        this.contextVars = null == contextVars ? Collections.emptyList() : Collections.unmodifiableList(contextVars);
        this.propagation = propagation == null ? ContextTrampoline.Propagation.OPTIMIZED : propagation;
        this.capturedContext = null == capturedContext ? Collections.emptyList() : Collections.unmodifiableList(capturedContext);
    }

    List<Object> enter() {
        List<Object> previousContextState = ContextTrampoline.Propagation.STRICT.equals((Object)this.propagation) ? ContextTrampoline.captureContext(this.contextVars) : Collections.nCopies(this.contextVars.size(), null);
        this.restoreContext(this.capturedContext);
        return previousContextState;
    }

    void exit(List<Object> previousContextState) {
        this.restoreContext(previousContextState);
    }

    private void restoreContext(List<Object> contextState) {
        Iterator<ContextVar<?>> vars = this.contextVars.iterator();
        Iterator<Object> values = contextState.iterator();
        while (vars.hasNext() && values.hasNext()) {
            ContextVar<?> contextVar = vars.next();
            Object contextVal = values.next();
            if (null == contextVal) {
                contextVar.remove();
                continue;
            }
            contextVar.set(contextVal);
        }
    }
}

