/*
 * Decompiled with CFR 0.152.
 */
package net.technearts.remote.enforcer;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import net.technearts.remote.enforcer.CheckerBuilder;
import net.technearts.remote.enforcer.DependencyChecker;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="check", defaultPhase=LifecyclePhase.VALIDATE)
public class CheckMojo
extends AbstractMojo {
    @Parameter(property="resources")
    private Map<String, URL> resources;
    @Parameter(property="showOnlyInvalidPaths", defaultValue="false")
    private boolean showOnlyInvalidPaths;

    public void execute() throws MojoExecutionException {
        this.resources.entrySet().parallelStream().forEach(entry -> {
            String dependency = (String)entry.getKey();
            try {
                URI uri = ((URL)entry.getValue()).toURI();
                DependencyChecker dependencyChecker = CheckerBuilder.build(uri);
                if (dependencyChecker.test(uri)) {
                    if (!this.showOnlyInvalidPaths) {
                        this.getLog().info((CharSequence)(dependency + " is OK!"));
                    }
                } else {
                    this.getLog().warn((CharSequence)(dependency + " is not OK"));
                }
            }
            catch (URISyntaxException e) {
                this.getLog().error((CharSequence)(dependency + " is not a valid URI"));
            }
            catch (IllegalStateException e) {
                this.getLog().error((CharSequence)(dependency + " could not be reached through this scheme"));
            }
        });
    }
}

