/*
 * Decompiled with CFR 0.152.
 */
package nl.changer.polypicker;

import nl.changer.polypicker.R;

public class Config {
    private int mTabBackgroundColor;
    private int mTabSelectionIndicatorColor;
    private int mSelectionLimit;
    private int mCameraButtonColor;

    public Config(int tabBgColor, int tabSelectionIndicatorColor, int selectionLimit, int cameraButtonColor) {
        this.mTabBackgroundColor = tabBgColor;
        this.mTabSelectionIndicatorColor = tabSelectionIndicatorColor;
        if (selectionLimit != -1) {
            this.mSelectionLimit = selectionLimit;
        }
        this.mCameraButtonColor = cameraButtonColor;
    }

    public int getCameraButtonColor() {
        return this.mCameraButtonColor;
    }

    public int getTabBackgroundColor() {
        return this.mTabBackgroundColor;
    }

    public int getTabSelectionIndicatorColor() {
        return this.mTabSelectionIndicatorColor;
    }

    public int getSelectionLimit() {
        return this.mSelectionLimit;
    }

    public static class Builder {
        private int mTabBackgroundColor = R.color.white;
        private int mTabSelectionIndicatorColor = R.color.orange;
        private int mSelectionLimit = Integer.MAX_VALUE;
        private int mCameraButtonColor = R.color.orange;

        public Builder setTabBackgroundColor(int colorRes) {
            if (colorRes == 0 || colorRes == -1) {
                throw new IllegalArgumentException("Invalid value for color");
            }
            this.mTabBackgroundColor = colorRes;
            return this;
        }

        public Builder setTabSelectionIndicatorColor(int colorRes) {
            if (colorRes == 0 || colorRes == -1) {
                throw new IllegalArgumentException("Invalid value for tab selection indicator color");
            }
            this.mTabSelectionIndicatorColor = colorRes;
            return this;
        }

        public Builder setSelectionLimit(int selectionLimit) {
            this.mSelectionLimit = selectionLimit;
            return this;
        }

        public Builder setCameraButtonColor(int buttonColorResId) {
            if (buttonColorResId == 0 || buttonColorResId == -1) {
                throw new IllegalArgumentException("Invalid value for camera button color");
            }
            this.mCameraButtonColor = buttonColorResId;
            return this;
        }

        public Config build() {
            return new Config(this.mTabBackgroundColor, this.mTabSelectionIndicatorColor, this.mSelectionLimit, this.mCameraButtonColor);
        }
    }
}

