/*
 * Decompiled with CFR 0.152.
 */
package nl.changer.polypicker;

import android.annotation.TargetApi;
import android.app.ProgressDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.commonsware.cwac.camera.CameraFragment;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.CameraUtils;
import com.commonsware.cwac.camera.PictureTransaction;
import com.commonsware.cwac.camera.SimpleCameraHost;
import nl.changer.polypicker.Config;
import nl.changer.polypicker.ImagePickerActivity;
import nl.changer.polypicker.R;
import nl.changer.polypicker.model.Image;

public class CwacCameraFragment
extends CameraFragment {
    private static final String KEY_USE_FFC = "com.commonsware.cwac.camera.demo.USE_FFC";
    private static final String TAG = CwacCameraFragment.class.getSimpleName();
    private MenuItem autoFocusItem = null;
    private MenuItem recordItem = null;
    String flashMode = null;
    private View mTakePictureBtn;
    private ProgressDialog mProgressDialog;
    private static Config mConfig;
    private View.OnClickListener mOnTakePictureClicked = new View.OnClickListener(){

        public void onClick(View view) {
            if (CwacCameraFragment.this.mTakePictureBtn.isEnabled()) {
                if (Build.VERSION.SDK_INT >= 16) {
                    CwacCameraFragment.this.autoFocus();
                } else {
                    CwacCameraFragment.this.takePicture();
                }
            }
        }
    };

    public void onCreate(Bundle state) {
        super.onCreate(state);
        this.setRetainInstance(true);
        SimpleCameraHost.Builder builder = new SimpleCameraHost.Builder((SimpleCameraHost)new DemoCameraHost((Context)this.getActivity()));
        this.setHost((CameraHost)builder.useFullBleedPreview(true).build());
        this.mProgressDialog = new ProgressDialog((Context)this.getActivity());
        this.mProgressDialog.setMessage((CharSequence)this.getString(R.string.progress_title));
        this.mProgressDialog.setIndeterminate(true);
        this.mProgressDialog.setCancelable(false);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View cameraView = super.onCreateView(inflater, container, savedInstanceState);
        View view = inflater.inflate(R.layout.fragment_camera_cwac, container, false);
        ((ViewGroup)view.findViewById(R.id.camera)).addView(cameraView);
        this.mTakePictureBtn = view.findViewById(R.id.take_picture);
        this.mTakePictureBtn.setOnClickListener(this.mOnTakePictureClicked);
        if (mConfig != null) {
            this.mTakePictureBtn.getBackground().setColorFilter(this.getResources().getColor(mConfig.getCameraButtonColor()), PorterDuff.Mode.DARKEN);
        }
        view.setKeepScreenOn(true);
        this.setRecordingItemVisibility();
        return view;
    }

    public static void setConfig(@Nullable Config config) {
        mConfig = config;
    }

    void setRecordingItemVisibility() {
        if (this.recordItem != null && this.getDisplayOrientation() != 0 && this.getDisplayOrientation() != 180) {
            this.recordItem.setVisible(false);
        }
    }

    public void takePicture() {
        this.mTakePictureBtn.setEnabled(false);
        this.mProgressDialog.show();
        PictureTransaction pictureTransaction = new PictureTransaction(this.getHost());
        pictureTransaction.needBitmap(true);
        pictureTransaction.flashMode(this.flashMode);
        super.takePicture(pictureTransaction);
    }

    public void onStop() {
        super.onStop();
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
        }
    }

    private class DemoCameraHost
    extends SimpleCameraHost
    implements Camera.FaceDetectionListener {
        boolean supportsFaces;

        public DemoCameraHost(Context _ctxt) {
            super(_ctxt);
            this.supportsFaces = false;
        }

        public boolean useFrontFacingCamera() {
            if (CwacCameraFragment.this.getArguments() == null) {
                return false;
            }
            return CwacCameraFragment.this.getArguments().getBoolean(CwacCameraFragment.KEY_USE_FFC);
        }

        public boolean useSingleShotMode() {
            return false;
        }

        public void saveImage(PictureTransaction xact, Bitmap bitmap) {
            String path = MediaStore.Images.Media.insertImage((ContentResolver)CwacCameraFragment.this.getActivity().getContentResolver(), (Bitmap)bitmap, (String)this.getPhotoFilename(), null);
            Uri contentUri = Uri.parse((String)path);
            final Image image = this.getImageFromContentUri(contentUri);
            CwacCameraFragment.this.getActivity().sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", contentUri));
            CwacCameraFragment.this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ((ImagePickerActivity)CwacCameraFragment.this.getActivity()).addImage(image);
                    CwacCameraFragment.this.mTakePictureBtn.setEnabled(true);
                    CwacCameraFragment.this.mProgressDialog.dismiss();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Image getImageFromContentUri(Uri contentUri) {
            String[] cols = new String[]{"_data", "orientation"};
            Cursor cursor = CwacCameraFragment.this.getActivity().getContentResolver().query(contentUri, cols, null, null, null);
            Uri uri = null;
            int orientation = -1;
            try {
                if (cursor.moveToFirst()) {
                    uri = Uri.parse((String)cursor.getString(cursor.getColumnIndex("_data")));
                    orientation = cursor.getInt(cursor.getColumnIndex("orientation"));
                }
            }
            catch (SQLiteException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (cursor != null && !cursor.isClosed()) {
                    cursor.close();
                }
            }
            return new Image(uri, orientation);
        }

        public void autoFocusAvailable() {
            if (CwacCameraFragment.this.autoFocusItem != null) {
                CwacCameraFragment.this.autoFocusItem.setEnabled(true);
                if (this.supportsFaces) {
                    CwacCameraFragment.this.startFaceDetection();
                }
            }
        }

        public void autoFocusUnavailable() {
            if (CwacCameraFragment.this.autoFocusItem != null) {
                CwacCameraFragment.this.stopFaceDetection();
                if (this.supportsFaces) {
                    CwacCameraFragment.this.autoFocusItem.setEnabled(false);
                }
            }
        }

        public void onCameraFail(CameraHost.FailureReason reason) {
            super.onCameraFail(reason);
            Toast.makeText((Context)CwacCameraFragment.this.getActivity(), (CharSequence)"Sorry, but you cannot use the camera now!", (int)1).show();
        }

        public Camera.Parameters adjustPreviewParameters(Camera.Parameters parameters) {
            CwacCameraFragment.this.flashMode = CameraUtils.findBestFlashModeMatch((Camera.Parameters)parameters, (String[])new String[]{"red-eye", "auto", "on"});
            if (parameters.getMaxNumDetectedFaces() > 0) {
                this.supportsFaces = true;
            } else {
                Log.w((String)TAG, (String)"Face detection not available for this camera");
            }
            return super.adjustPreviewParameters(parameters);
        }

        public void onFaceDetection(Camera.Face[] faces, Camera camera) {
        }

        @TargetApi(value=16)
        public void onAutoFocus(boolean success, Camera camera) {
            super.onAutoFocus(success, camera);
            CwacCameraFragment.this.takePicture();
        }
    }
}

