/*
 * Decompiled with CFR 0.152.
 */
package nl.changer.polypicker;

import android.app.Fragment;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import nl.changer.polypicker.ImagePickerActivity;
import nl.changer.polypicker.R;
import nl.changer.polypicker.model.Image;

public class GalleryFragment
extends Fragment {
    private static final String TAG = GalleryFragment.class.getSimpleName();
    private ImageGalleryAdapter mGalleryAdapter;
    private ImagePickerActivity mActivity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_gallery, container, false);
        this.mGalleryAdapter = new ImageGalleryAdapter((Context)this.getActivity());
        GridView galleryGridView = (GridView)rootView.findViewById(R.id.gallery_grid);
        this.mActivity = (ImagePickerActivity)this.getActivity();
        Cursor imageCursor = null;
        try {
            String[] columns = new String[]{"_data", "orientation"};
            String orderBy = "date_added DESC";
            imageCursor = this.getActivity().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, columns, null, null, "date_added DESC");
            while (imageCursor.moveToNext()) {
                Uri uri = Uri.parse((String)imageCursor.getString(imageCursor.getColumnIndex("_data")));
                int orientation = imageCursor.getInt(imageCursor.getColumnIndex("orientation"));
                this.mGalleryAdapter.add(new Image(uri, orientation));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (imageCursor != null && !imageCursor.isClosed()) {
                imageCursor.close();
            }
        }
        galleryGridView.setAdapter((ListAdapter)this.mGalleryAdapter);
        galleryGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Image image = (Image)GalleryFragment.this.mGalleryAdapter.getItem(i);
                if (!GalleryFragment.this.mActivity.containsImage(image)) {
                    GalleryFragment.this.mActivity.addImage(image);
                } else {
                    GalleryFragment.this.mActivity.removeImage(image);
                }
                GalleryFragment.this.mGalleryAdapter.notifyDataSetChanged();
            }
        });
        return rootView;
    }

    public class ImageGalleryAdapter
    extends ArrayAdapter<Image> {
        public ImageGalleryAdapter(Context context) {
            super(context, 0);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.grid_item_gallery_thumbnail, null);
                holder = new ViewHolder();
                holder.mThumbnail = (ImageView)convertView.findViewById(R.id.thumbnail_image);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            Image image = (Image)this.getItem(position);
            boolean isSelected = GalleryFragment.this.mActivity.containsImage(image);
            ((FrameLayout)convertView).setForeground(isSelected ? GalleryFragment.this.getResources().getDrawable(R.drawable.gallery_photo_selected) : null);
            if (holder.mImage == null || !holder.mImage.equals(image)) {
                ((GalleryFragment)GalleryFragment.this).mActivity.mImageFetcher.loadImage(image.mUri, holder.mThumbnail);
                holder.mImage = image;
            }
            return convertView;
        }
    }

    class ViewHolder {
        ImageView mThumbnail;
        Image mImage;

        ViewHolder() {
        }
    }
}

