/*
 * Decompiled with CFR 0.152.
 */
package nl.changer.polypicker;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.ActionBarActivity;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import nl.changer.polypicker.Config;
import nl.changer.polypicker.PagerAdapter2Fragments;
import nl.changer.polypicker.R;
import nl.changer.polypicker.SlidingTabText;
import nl.changer.polypicker.model.Image;
import nl.changer.polypicker.utils.ImageInternalFetcher;

public class ImagePickerActivity
extends ActionBarActivity {
    private static final String KEY_LIST = "nl.changer.polypicker.savedinstance.key.list";
    public static final String EXTRA_IMAGE_URIS = "nl.changer.changer.nl.polypicker.extra.selected_image_uris";
    private Set<Image> mSelectedImages;
    private LinearLayout mSelectedImagesContainer;
    protected TextView mSelectedImageEmptyMessage;
    private ViewPager mViewPager;
    public ImageInternalFetcher mImageFetcher;
    private Button mCancelButtonView;
    private Button mDoneButtonView;
    private SlidingTabText mSlidingTabText;
    private static Config mConfig = new Config.Builder().build();
    private View.OnClickListener mOnFinishGettingImages = new View.OnClickListener(){

        public void onClick(View view) {
            if (view.getId() == R.id.action_btn_done) {
                Uri[] uris = new Uri[ImagePickerActivity.this.mSelectedImages.size()];
                int i = 0;
                for (Image img : ImagePickerActivity.this.mSelectedImages) {
                    uris[i++] = img.mUri;
                }
                Intent intent = new Intent();
                intent.putExtra(ImagePickerActivity.EXTRA_IMAGE_URIS, (Parcelable[])uris);
                ImagePickerActivity.this.setResult(-1, intent);
            } else if (view.getId() == R.id.action_btn_cancel) {
                ImagePickerActivity.this.setResult(0);
            }
            ImagePickerActivity.this.finish();
        }
    };

    public static void setConfig(Config config) {
        if (config == null) {
            throw new NullPointerException("Config cannot be passed null. Not setting config will use default values.");
        }
        mConfig = config;
    }

    public static Config getConfig() {
        return mConfig;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_main_pp);
        this.mSelectedImagesContainer = (LinearLayout)this.findViewById(R.id.selected_photos_container);
        this.mSelectedImageEmptyMessage = (TextView)this.findViewById(R.id.selected_photos_empty);
        this.mViewPager = (ViewPager)this.findViewById(R.id.pager);
        this.mCancelButtonView = (Button)this.findViewById(R.id.action_btn_cancel);
        this.mDoneButtonView = (Button)this.findViewById(R.id.action_btn_done);
        this.mSelectedImages = new HashSet<Image>();
        this.mImageFetcher = new ImageInternalFetcher((Context)this, 500);
        this.mCancelButtonView.setOnClickListener(this.mOnFinishGettingImages);
        this.mDoneButtonView.setOnClickListener(this.mOnFinishGettingImages);
        this.setupActionBar();
        if (savedInstanceState != null) {
            this.populateUi(savedInstanceState);
        }
    }

    private void populateUi(Bundle savedInstanceState) {
        ArrayList list = savedInstanceState.getParcelableArrayList(KEY_LIST);
        if (list != null) {
            for (Image image : list) {
                this.addImage(image);
            }
        }
    }

    private void setupActionBar() {
        this.mSlidingTabText = (SlidingTabText)this.findViewById(R.id.sliding_tabs);
        this.mSlidingTabText.setSelectedIndicatorColors(this.getResources().getColor(mConfig.getTabSelectionIndicatorColor()));
        this.mSlidingTabText.setCustomTabView(R.layout.tab_view_text, R.id.tab_icon);
        this.mSlidingTabText.setTabStripColor(mConfig.getTabBackgroundColor());
        this.mViewPager.setAdapter((PagerAdapter)new PagerAdapter2Fragments(this.getFragmentManager()));
        this.mSlidingTabText.setTabTitles(this.getResources().getStringArray(R.array.tab_titles));
        this.mSlidingTabText.setViewPager(this.mViewPager);
    }

    public boolean addImage(Image image) {
        if (this.mSelectedImages == null) {
            this.mSelectedImages = new HashSet<Image>();
        }
        if (this.mSelectedImages.size() == mConfig.getSelectionLimit()) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.n_images_selected, new Object[]{mConfig.getSelectionLimit()}), (int)0).show();
            return false;
        }
        if (this.mSelectedImages.add(image)) {
            View rootView = LayoutInflater.from((Context)this).inflate(R.layout.list_item_selected_thumbnail, null);
            ImageView thumbnail = (ImageView)rootView.findViewById(R.id.selected_photo);
            rootView.setTag((Object)image.mUri);
            this.mImageFetcher.loadImage(image.mUri, thumbnail);
            this.mSelectedImagesContainer.addView(rootView, 0);
            int px = (int)TypedValue.applyDimension((int)1, (float)60.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            thumbnail.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(px, px));
            if (this.mSelectedImages.size() >= 1) {
                this.mSelectedImagesContainer.setVisibility(0);
                this.mSelectedImageEmptyMessage.setVisibility(8);
            }
            return true;
        }
        return false;
    }

    public boolean removeImage(Image image) {
        if (this.mSelectedImages.remove(image)) {
            for (int i = 0; i < this.mSelectedImagesContainer.getChildCount(); ++i) {
                View childView = this.mSelectedImagesContainer.getChildAt(i);
                if (!childView.getTag().equals(image.mUri)) continue;
                this.mSelectedImagesContainer.removeViewAt(i);
                break;
            }
            if (this.mSelectedImages.size() == 0) {
                this.mSelectedImagesContainer.setVisibility(8);
                this.mSelectedImageEmptyMessage.setVisibility(0);
            }
            return true;
        }
        return false;
    }

    public boolean containsImage(Image image) {
        return this.mSelectedImages.contains(image);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        ArrayList<Image> list = new ArrayList<Image>(this.mSelectedImages);
        outState.putParcelableArrayList(KEY_LIST, list);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.populateUi(savedInstanceState);
    }
}

