/*
 * Decompiled with CFR 0.152.
 */
package nl.changer.polypicker;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.TextView;
import nl.changer.polypicker.SlidingTabStrip;

public class SlidingTabLayout
extends HorizontalScrollView {
    private static final String TAG = SlidingTabLayout.class.getSimpleName();
    private static final int TITLE_OFFSET_DIPS = 24;
    private static final int TAB_VIEW_PADDING_DIPS = 16;
    private static final int TAB_VIEW_TEXT_SIZE_SP = 12;
    private int mTitleOffset;
    protected int mTabViewLayoutId;
    protected int mTabViewImageViewId;
    protected ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mViewPagerPageChangeListener;
    protected final SlidingTabStrip mTabStrip;

    public SlidingTabLayout(Context context) {
        this(context, null);
    }

    public SlidingTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SlidingTabLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setHorizontalScrollBarEnabled(false);
        this.setFillViewport(true);
        this.mTitleOffset = (int)(24.0f * this.getResources().getDisplayMetrics().density);
        this.mTabStrip = new SlidingTabStrip(context);
        this.addView((View)this.mTabStrip, -1, -2);
    }

    public void setCustomTabColorizer(TabColorizer tabColorizer) {
        this.mTabStrip.setCustomTabColorizer(tabColorizer);
    }

    public void setSelectedIndicatorColors(int ... colors) {
        this.mTabStrip.setSelectedIndicatorColors(colors);
    }

    public void setDividerColors(int ... colors) {
        this.mTabStrip.setDividerColors(colors);
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mViewPagerPageChangeListener = listener;
    }

    public void setCustomTabView(int layoutResId, int ImageViewId) {
        this.mTabViewLayoutId = layoutResId;
        this.mTabViewImageViewId = ImageViewId;
    }

    public void setViewPager(ViewPager viewPager) {
        this.mTabStrip.removeAllViews();
        this.mViewPager = viewPager;
        if (viewPager != null) {
            viewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new InternalViewPagerListener());
            Log.v((String)TAG, (String)"#populateTabStrip: ViewPager is not null");
            this.populateTabStrip();
        }
    }

    protected TextView createDefaultTabView(Context context) {
        TextView textView = new TextView(context);
        textView.setGravity(17);
        textView.setTextSize(2, 12.0f);
        textView.setTypeface(Typeface.DEFAULT_BOLD);
        if (Build.VERSION.SDK_INT >= 11) {
            TypedValue outValue = new TypedValue();
            this.getContext().getTheme().resolveAttribute(16843534, outValue, true);
            textView.setBackgroundResource(outValue.resourceId);
        }
        if (Build.VERSION.SDK_INT >= 14) {
            textView.setAllCaps(true);
        }
        int padding = (int)(16.0f * this.getResources().getDisplayMetrics().density);
        textView.setPadding(padding, padding, padding, padding);
        return textView;
    }

    public SlidingTabStrip getTabStrip() {
        return this.mTabStrip;
    }

    protected void populateTabStrip() {
        PagerAdapter adapter = this.mViewPager.getAdapter();
        TabClickListener tabClickListener = new TabClickListener();
        for (int i = 0; i < adapter.getCount(); ++i) {
            View tabView = null;
            ImageView tabTitleView = null;
            if (this.mTabViewLayoutId != 0) {
                tabView = LayoutInflater.from((Context)this.getContext()).inflate(this.mTabViewLayoutId, (ViewGroup)this.mTabStrip, false);
                tabTitleView = (ImageView)tabView.findViewById(this.mTabViewImageViewId);
                Log.v((String)TAG, (String)"#populateTabStrip: tab_view_layout is not null");
            }
            if (tabView == null) {
                Log.v((String)TAG, (String)"#populateTabStrip: tab view is null");
                tabView = this.createDefaultTabView(this.getContext());
            }
            if (tabTitleView == null && ImageView.class.isInstance(tabView)) {
                Log.v((String)TAG, (String)"#populateTabStrip: tabtitleView is null");
                tabTitleView = (ImageView)tabView;
            }
            tabView.setOnClickListener((View.OnClickListener)tabClickListener);
            this.mTabStrip.addView(tabView);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mViewPager != null) {
            this.scrollToTab(this.mViewPager.getCurrentItem(), 0);
        }
    }

    private void scrollToTab(int tabIndex, int positionOffset) {
        int tabStripChildCount = this.mTabStrip.getChildCount();
        if (tabStripChildCount == 0 || tabIndex < 0 || tabIndex >= tabStripChildCount) {
            return;
        }
        View selectedChild = this.mTabStrip.getChildAt(tabIndex);
        if (selectedChild != null) {
            int targetScrollX = selectedChild.getLeft() + positionOffset;
            if (tabIndex > 0 || positionOffset > 0) {
                targetScrollX -= this.mTitleOffset;
            }
            this.scrollTo(targetScrollX, 0);
        }
    }

    protected class TabClickListener
    implements View.OnClickListener {
        protected TabClickListener() {
        }

        public void onClick(View v) {
            for (int i = 0; i < SlidingTabLayout.this.mTabStrip.getChildCount(); ++i) {
                if (v != SlidingTabLayout.this.mTabStrip.getChildAt(i)) continue;
                SlidingTabLayout.this.mViewPager.setCurrentItem(i);
                return;
            }
        }
    }

    protected class InternalViewPagerListener
    implements ViewPager.OnPageChangeListener {
        private int mScrollState;

        protected InternalViewPagerListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            int tabStripChildCount = SlidingTabLayout.this.mTabStrip.getChildCount();
            if (tabStripChildCount == 0 || position < 0 || position >= tabStripChildCount) {
                return;
            }
            SlidingTabLayout.this.mTabStrip.onViewPagerPageChanged(position, positionOffset);
            View selectedTitle = SlidingTabLayout.this.mTabStrip.getChildAt(position);
            int extraOffset = selectedTitle != null ? (int)(positionOffset * (float)selectedTitle.getWidth()) : 0;
            SlidingTabLayout.this.scrollToTab(position, extraOffset);
            if (SlidingTabLayout.this.mViewPagerPageChangeListener != null) {
                SlidingTabLayout.this.mViewPagerPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageScrollStateChanged(int state) {
            this.mScrollState = state;
            if (SlidingTabLayout.this.mViewPagerPageChangeListener != null) {
                SlidingTabLayout.this.mViewPagerPageChangeListener.onPageScrollStateChanged(state);
            }
        }

        public void onPageSelected(int position) {
            if (this.mScrollState == 0) {
                SlidingTabLayout.this.mTabStrip.onViewPagerPageChanged(position, 0.0f);
                SlidingTabLayout.this.scrollToTab(position, 0);
            }
            if (SlidingTabLayout.this.mViewPagerPageChangeListener != null) {
                SlidingTabLayout.this.mViewPagerPageChangeListener.onPageSelected(position);
            }
        }
    }

    public static interface TabColorizer {
        public int getIndicatorColor(int var1);

        public int getDividerColor(int var1);
    }
}

