/*
 * Decompiled with CFR 0.152.
 */
package nl.changer.polypicker;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.widget.LinearLayout;
import nl.changer.polypicker.SlidingTabLayout;

public class SlidingTabStrip
extends LinearLayout {
    private static final int DEFAULT_BOTTOM_BORDER_THICKNESS_DIPS = 2;
    private static final byte DEFAULT_BOTTOM_BORDER_COLOR_ALPHA = 64;
    private static final int SELECTED_INDICATOR_THICKNESS_DIPS = 5;
    private static final int DEFAULT_SELECTED_INDICATOR_COLOR = -1;
    private static final int DEFAULT_DIVIDER_THICKNESS_DIPS = 1;
    private static final byte DEFAULT_DIVIDER_COLOR_ALPHA = 32;
    private static final float DEFAULT_DIVIDER_HEIGHT = 0.5f;
    private final int mBottomBorderThickness;
    private final Paint mBottomBorderPaint;
    private final int mSelectedIndicatorThickness;
    private final Paint mSelectedIndicatorPaint;
    private final int mDefaultBottomBorderColor;
    private final Paint mDividerPaint;
    private final float mDividerHeight;
    private int mSelectedPosition;
    private float mSelectionOffset;
    private SlidingTabLayout.TabColorizer mCustomTabColorizer;
    private final SimpleTabColorizer mDefaultTabColorizer;

    SlidingTabStrip(Context context) {
        this(context, null);
    }

    SlidingTabStrip(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
        float density = this.getResources().getDisplayMetrics().density;
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(0x1010030, outValue, true);
        int themeForegroundColor = outValue.data;
        this.mDefaultBottomBorderColor = SlidingTabStrip.setColorAlpha(themeForegroundColor, (byte)64);
        this.mDefaultTabColorizer = new SimpleTabColorizer();
        this.mDefaultTabColorizer.setIndicatorColors(-1);
        this.mDefaultTabColorizer.setDividerColors(SlidingTabStrip.setColorAlpha(themeForegroundColor, (byte)32));
        this.mBottomBorderThickness = (int)(2.0f * density);
        this.mBottomBorderPaint = new Paint();
        this.mBottomBorderPaint.setColor(this.mDefaultBottomBorderColor);
        this.mSelectedIndicatorThickness = (int)(5.0f * density);
        this.mSelectedIndicatorPaint = new Paint();
        this.mDividerHeight = 0.5f;
        this.mDividerPaint = new Paint();
        this.mDividerPaint.setStrokeWidth((float)((int)(1.0f * density)));
    }

    void setCustomTabColorizer(SlidingTabLayout.TabColorizer customTabColorizer) {
        this.mCustomTabColorizer = customTabColorizer;
        this.invalidate();
    }

    void setSelectedIndicatorColors(int ... colors) {
        this.mCustomTabColorizer = null;
        this.mDefaultTabColorizer.setIndicatorColors(colors);
        this.invalidate();
    }

    void setDividerColors(int ... colors) {
        this.mCustomTabColorizer = null;
        this.mDefaultTabColorizer.setDividerColors(colors);
        this.invalidate();
    }

    void onViewPagerPageChanged(int position, float positionOffset) {
        this.mSelectedPosition = position;
        this.mSelectionOffset = positionOffset;
        this.invalidate();
    }

    @TargetApi(value=17)
    protected void onDraw(Canvas canvas) {
        SlidingTabLayout.TabColorizer tabColorizer;
        int height = this.getHeight();
        int childCount = this.getChildCount();
        int dividerHeightPx = (int)(Math.min(Math.max(0.0f, this.mDividerHeight), 1.0f) * (float)height);
        SlidingTabLayout.TabColorizer tabColorizer2 = tabColorizer = this.mCustomTabColorizer != null ? this.mCustomTabColorizer : this.mDefaultTabColorizer;
        if (childCount > 0) {
            View selectedTitle = this.getChildAt(this.mSelectedPosition);
            int left = selectedTitle.getLeft();
            int right = selectedTitle.getRight();
            int color2 = tabColorizer.getIndicatorColor(this.mSelectedPosition);
            if (this.mSelectionOffset > 0.0f && this.mSelectedPosition < this.getChildCount() - 1) {
                int nextColor = tabColorizer.getIndicatorColor(this.mSelectedPosition + 1);
                if (color2 != nextColor) {
                    color2 = SlidingTabStrip.blendColors(nextColor, color2, this.mSelectionOffset);
                }
                View nextTitle = this.getChildAt(this.mSelectedPosition + 1);
                left = (int)(this.mSelectionOffset * (float)nextTitle.getLeft() + (1.0f - this.mSelectionOffset) * (float)left);
                right = (int)(this.mSelectionOffset * (float)nextTitle.getRight() + (1.0f - this.mSelectionOffset) * (float)right);
            }
            this.mSelectedIndicatorPaint.setColor(color2);
            canvas.drawRect((float)left, (float)(height - this.mSelectedIndicatorThickness), (float)right, (float)height, this.mSelectedIndicatorPaint);
        }
        canvas.drawRect(0.0f, (float)(height - this.mBottomBorderThickness), (float)this.getWidth(), (float)height, this.mBottomBorderPaint);
        int separatorTop = (height - dividerHeightPx) / 2;
        for (int i = 0; i < childCount - 1; ++i) {
            View child = this.getChildAt(i);
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)child.getLayoutParams();
            this.mDividerPaint.setColor(tabColorizer.getDividerColor(i));
            canvas.drawLine((float)(child.getRight() + params.getMarginEnd()), (float)separatorTop, (float)(child.getRight() + params.getMarginEnd()), (float)(separatorTop + dividerHeightPx), this.mDividerPaint);
        }
    }

    private static int setColorAlpha(int color2, byte alpha) {
        return Color.argb((int)alpha, (int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2));
    }

    private static int blendColors(int color1, int color2, float ratio) {
        float inverseRation = 1.0f - ratio;
        float r = (float)Color.red((int)color1) * ratio + (float)Color.red((int)color2) * inverseRation;
        float g = (float)Color.green((int)color1) * ratio + (float)Color.green((int)color2) * inverseRation;
        float b = (float)Color.blue((int)color1) * ratio + (float)Color.blue((int)color2) * inverseRation;
        return Color.rgb((int)((int)r), (int)((int)g), (int)((int)b));
    }

    private static class SimpleTabColorizer
    implements SlidingTabLayout.TabColorizer {
        private int[] mIndicatorColors;
        private int[] mDividerColors;

        private SimpleTabColorizer() {
        }

        @Override
        public final int getIndicatorColor(int position) {
            return this.mIndicatorColors[position % this.mIndicatorColors.length];
        }

        @Override
        public final int getDividerColor(int position) {
            return this.mDividerColors[position % this.mDividerColors.length];
        }

        void setIndicatorColors(int ... colors) {
            this.mIndicatorColors = colors;
        }

        void setDividerColors(int ... colors) {
            this.mDividerColors = colors;
        }
    }
}

