/*
 * Decompiled with CFR 0.152.
 */
package nl.changer.polypicker;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import nl.changer.polypicker.SlidingTabLayout;
import nl.changer.polypicker.utils.DebugLog;

public class SlidingTabText
extends SlidingTabLayout {
    private String[] mTabText;

    public SlidingTabText(Context context) {
        super(context);
    }

    public SlidingTabText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SlidingTabText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setTabTitles(String[] titles) {
        if (this.mViewPager != null && titles.length != this.mViewPager.getChildCount()) {
            throw new IllegalArgumentException("Titles and View pager count mismatch. Expected " + this.mViewPager.getChildCount() + "Found " + this.mTabText.length);
        }
        this.mTabText = titles;
    }

    public void setTabStripColor(int color) {
        this.mTabStrip.setBackgroundResource(color);
    }

    @Override
    public void setViewPager(ViewPager viewPager) {
        this.mTabStrip.removeAllViews();
        this.mViewPager = viewPager;
        if (viewPager != null) {
            viewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new SlidingTabLayout.InternalViewPagerListener(this));
            if (this.mTabText == null || this.mTabText.length == 0) {
                int size = this.mViewPager.getAdapter().getCount();
                this.mTabText = new String[size];
                for (int i = 0; i < size; ++i) {
                    this.mTabText[i] = Integer.toString(i);
                }
            }
            if (viewPager.getAdapter().getCount() != this.mTabText.length) {
                throw new IllegalArgumentException("Titles and View pager count mismatch. Expected " + viewPager.getChildCount() + " Found " + this.mTabText.length);
            }
            this.populateTabStrip();
        }
    }

    @Override
    protected void populateTabStrip() {
        PagerAdapter adapter = this.mViewPager.getAdapter();
        SlidingTabLayout.TabClickListener tabClickListener = new SlidingTabLayout.TabClickListener(this);
        for (int i = 0; i < adapter.getCount(); ++i) {
            TextView tabView = null;
            TextView tabTitleView = null;
            ImageView tabImageView = null;
            if (this.mTabViewLayoutId != 0) {
                tabView = LayoutInflater.from((Context)this.getContext()).inflate(this.mTabViewLayoutId, (ViewGroup)this.mTabStrip, false);
                View tabViewDescendant = tabView.findViewById(this.mTabViewImageViewId);
                if (tabViewDescendant instanceof TextView) {
                    tabTitleView = (TextView)tabViewDescendant;
                } else if (tabViewDescendant instanceof ImageView) {
                    tabImageView = (ImageView)tabViewDescendant;
                }
                DebugLog.v("#populateTabStrip: tab_view_layout is not null");
            }
            if (tabView == null) {
                DebugLog.v("#populateTabStrip: tab view is null");
                tabView = this.createDefaultTabView(this.getContext());
            }
            if (tabTitleView == null && ImageView.class.isInstance(tabView)) {
                tabImageView = (ImageView)tabView;
            } else if (tabTitleView == null && TextView.class.isInstance(tabTitleView)) {
                tabTitleView = tabView;
            }
            if (tabTitleView != null) {
                tabTitleView.setText((CharSequence)this.mTabText[i]);
            }
            tabView.setOnClickListener((View.OnClickListener)tabClickListener);
            this.mTabStrip.addView((View)tabView);
        }
    }
}

