/*
 * Decompiled with CFR 0.152.
 */
package nl.changer.polypicker.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.os.Bundle;
import android.os.Environment;
import android.os.StatFs;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.util.LruCache;
import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import nl.changer.polypicker.utils.DiskLruCache;
import nl.changer.polypicker.utils.ImageResizer;
import nl.changer.polypicker.utils.RecyclingBitmapDrawable;
import nl.changer.polypicker.utils.Utils;

public class ImageCache {
    private static final String TAG = "ImageCache";
    private static final int DEFAULT_MEM_CACHE_SIZE = 5120;
    private static final int DEFAULT_DISK_CACHE_SIZE = 0xA00000;
    private static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.JPEG;
    private static final int DEFAULT_COMPRESS_QUALITY = 70;
    private static final int DISK_CACHE_INDEX = 0;
    private static final boolean DEFAULT_MEM_CACHE_ENABLED = true;
    private static final boolean DEFAULT_DISK_CACHE_ENABLED = true;
    private static final boolean DEFAULT_INIT_DISK_CACHE_ON_CREATE = false;
    private DiskLruCache mDiskLruCache;
    private LruCache<String, BitmapDrawable> mMemoryCache;
    private ImageCacheParams mCacheParams;
    private final Object mDiskCacheLock = new Object();
    private boolean mDiskCacheStarting = true;
    private Set<SoftReference<Bitmap>> mReusableBitmaps;

    private ImageCache(ImageCacheParams cacheParams) {
        this.init(cacheParams);
    }

    public static ImageCache getInstance(FragmentManager fragmentManager, ImageCacheParams cacheParams) {
        RetainFragment mRetainFragment = ImageCache.findOrCreateRetainFragment(fragmentManager);
        ImageCache imageCache = (ImageCache)mRetainFragment.getObject();
        if (imageCache == null) {
            imageCache = new ImageCache(cacheParams);
            mRetainFragment.setObject(imageCache);
        }
        return imageCache;
    }

    private void init(ImageCacheParams cacheParams) {
        this.mCacheParams = cacheParams;
        if (this.mCacheParams.memoryCacheEnabled) {
            if (Utils.hasHoneycomb()) {
                this.mReusableBitmaps = Collections.synchronizedSet(new HashSet());
            }
            this.mMemoryCache = new LruCache<String, BitmapDrawable>(this.mCacheParams.memCacheSize){

                protected void entryRemoved(boolean evicted, String key, BitmapDrawable oldValue, BitmapDrawable newValue) {
                    if (RecyclingBitmapDrawable.class.isInstance(oldValue)) {
                        ((RecyclingBitmapDrawable)oldValue).setIsCached(false);
                    } else if (Utils.hasHoneycomb()) {
                        ImageCache.this.mReusableBitmaps.add(new SoftReference<Bitmap>(oldValue.getBitmap()));
                    }
                }

                protected int sizeOf(String key, BitmapDrawable value) {
                    int bitmapSize = ImageCache.getBitmapSize(value) / 1024;
                    return bitmapSize == 0 ? 1 : bitmapSize;
                }
            };
        }
        if (cacheParams.initDiskCacheOnCreate) {
            this.initDiskCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache == null || this.mDiskLruCache.isClosed()) {
                File diskCacheDir = this.mCacheParams.diskCacheDir;
                if (this.mCacheParams.diskCacheEnabled && diskCacheDir != null) {
                    if (!diskCacheDir.exists()) {
                        diskCacheDir.mkdirs();
                    }
                    if (ImageCache.getUsableSpace(diskCacheDir) > (long)this.mCacheParams.diskCacheSize) {
                        try {
                            this.mDiskLruCache = DiskLruCache.open(diskCacheDir, 1, 1, this.mCacheParams.diskCacheSize);
                        }
                        catch (IOException e) {
                            this.mCacheParams.diskCacheDir = null;
                            Log.e((String)TAG, (String)("initDiskCache - " + e));
                        }
                    }
                }
            }
            this.mDiskCacheStarting = false;
            this.mDiskCacheLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBitmapToCache(String data, BitmapDrawable value) {
        if (data == null || value == null) {
            return;
        }
        if (this.mMemoryCache != null) {
            if (RecyclingBitmapDrawable.class.isInstance(value)) {
                ((RecyclingBitmapDrawable)value).setIsCached(true);
            }
            this.mMemoryCache.put((Object)data, (Object)value);
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                String key = ImageCache.hashKeyForDisk(data);
                OutputStream out = null;
                try {
                    DiskLruCache.Snapshot snapshot = this.mDiskLruCache.get(key);
                    if (snapshot == null) {
                        DiskLruCache.Editor editor = this.mDiskLruCache.edit(key);
                        if (editor != null) {
                            out = editor.newOutputStream(0);
                            value.getBitmap().compress(this.mCacheParams.compressFormat, this.mCacheParams.compressQuality, out);
                            editor.commit();
                            out.close();
                        }
                    } else {
                        snapshot.getInputStream(0).close();
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("addBitmapToCache - " + e));
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("addBitmapToCache - " + e));
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public BitmapDrawable getBitmapFromMemCache(String data) {
        BitmapDrawable memValue = null;
        if (this.mMemoryCache != null) {
            memValue = (BitmapDrawable)this.mMemoryCache.get((Object)data);
        }
        return memValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmapFromDiskCache(String data) {
        String key = ImageCache.hashKeyForDisk(data);
        Bitmap bitmap = null;
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            while (this.mDiskCacheStarting) {
                try {
                    this.mDiskCacheLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.mDiskLruCache != null) {
                InputStream inputStream = null;
                try {
                    DiskLruCache.Snapshot snapshot = this.mDiskLruCache.get(key);
                    if (snapshot != null && (inputStream = snapshot.getInputStream(0)) != null) {
                        FileDescriptor fd = ((FileInputStream)inputStream).getFD();
                        bitmap = ImageResizer.decodeSampledBitmapFromDescriptor(fd, Integer.MAX_VALUE, Integer.MAX_VALUE, this);
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("getBitmapFromDiskCache - " + e));
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return bitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bitmap getBitmapFromReusableSet(BitmapFactory.Options options) {
        Bitmap bitmap = null;
        if (this.mReusableBitmaps != null && !this.mReusableBitmaps.isEmpty()) {
            Set<SoftReference<Bitmap>> set = this.mReusableBitmaps;
            synchronized (set) {
                Iterator<SoftReference<Bitmap>> iterator = this.mReusableBitmaps.iterator();
                while (iterator.hasNext()) {
                    Bitmap item = iterator.next().get();
                    if (null != item && item.isMutable()) {
                        if (!ImageCache.canUseForInBitmap(item, options)) continue;
                        bitmap = item;
                        iterator.remove();
                        break;
                    }
                    iterator.remove();
                }
            }
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.evictAll();
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            this.mDiskCacheStarting = true;
            if (this.mDiskLruCache != null && !this.mDiskLruCache.isClosed()) {
                try {
                    this.mDiskLruCache.delete();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("clearCache - " + e));
                }
                this.mDiskLruCache = null;
                this.initDiskCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                try {
                    this.mDiskLruCache.flush();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("flush - " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                try {
                    if (!this.mDiskLruCache.isClosed()) {
                        this.mDiskLruCache.close();
                        this.mDiskLruCache = null;
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("close - " + e));
                }
            }
        }
    }

    @TargetApi(value=19)
    private static boolean canUseForInBitmap(Bitmap candidate, BitmapFactory.Options targetOptions) {
        if (!Utils.hasKitKat()) {
            return candidate.getWidth() == targetOptions.outWidth && candidate.getHeight() == targetOptions.outHeight && targetOptions.inSampleSize == 1;
        }
        int width = targetOptions.outWidth / targetOptions.inSampleSize;
        int height = targetOptions.outHeight / targetOptions.inSampleSize;
        int byteCount = width * height * ImageCache.getBytesPerPixel(candidate.getConfig());
        return byteCount <= candidate.getAllocationByteCount();
    }

    private static int getBytesPerPixel(Bitmap.Config config) {
        if (config == Bitmap.Config.ARGB_8888) {
            return 4;
        }
        if (config == Bitmap.Config.RGB_565) {
            return 2;
        }
        if (config == Bitmap.Config.ARGB_4444) {
            return 2;
        }
        if (config == Bitmap.Config.ALPHA_8) {
            return 1;
        }
        return 1;
    }

    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = "mounted".equals(Environment.getExternalStorageState()) || !ImageCache.isExternalStorageRemovable() ? ImageCache.getExternalCacheDir(context).getPath() : context.getCacheDir().getPath();
        return new File(cachePath + File.separator + uniqueName);
    }

    public static String hashKeyForDisk(String key) {
        String cacheKey;
        try {
            MessageDigest mDigest = MessageDigest.getInstance("MD5");
            mDigest.update(key.getBytes());
            cacheKey = ImageCache.bytesToHexString(mDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            cacheKey = String.valueOf(key.hashCode());
        }
        return cacheKey;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    @TargetApi(value=19)
    public static int getBitmapSize(BitmapDrawable value) {
        Bitmap bitmap = value.getBitmap();
        if (Utils.hasKitKat()) {
            return bitmap.getAllocationByteCount();
        }
        if (Utils.hasHoneycombMR1()) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    @TargetApi(value=9)
    public static boolean isExternalStorageRemovable() {
        if (Utils.hasGingerbread()) {
            return Environment.isExternalStorageRemovable();
        }
        return true;
    }

    @TargetApi(value=8)
    public static File getExternalCacheDir(Context context) {
        if (Utils.hasFroyo()) {
            return context.getExternalCacheDir();
        }
        String cacheDir = "/Android/data/" + context.getPackageName() + "/cache/";
        return new File(Environment.getExternalStorageDirectory().getPath() + cacheDir);
    }

    @TargetApi(value=9)
    public static long getUsableSpace(File path) {
        if (Utils.hasGingerbread()) {
            return path.getUsableSpace();
        }
        StatFs stats = new StatFs(path.getPath());
        return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
    }

    private static RetainFragment findOrCreateRetainFragment(FragmentManager fm) {
        RetainFragment mRetainFragment = (RetainFragment)fm.findFragmentByTag(TAG);
        if (mRetainFragment == null) {
            mRetainFragment = new RetainFragment();
            fm.beginTransaction().add((Fragment)mRetainFragment, TAG).commitAllowingStateLoss();
        }
        return mRetainFragment;
    }

    static /* synthetic */ Bitmap.CompressFormat access$100() {
        return DEFAULT_COMPRESS_FORMAT;
    }

    public static class RetainFragment
    extends Fragment {
        private Object mObject;

        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.setRetainInstance(true);
        }

        public void setObject(Object object) {
            this.mObject = object;
        }

        public Object getObject() {
            return this.mObject;
        }
    }

    public static class ImageCacheParams {
        public int memCacheSize = 5120;
        public int diskCacheSize = 0xA00000;
        public File diskCacheDir;
        public Bitmap.CompressFormat compressFormat = ImageCache.access$100();
        public int compressQuality = 70;
        public boolean memoryCacheEnabled = true;
        public boolean diskCacheEnabled = true;
        public boolean initDiskCacheOnCreate = false;

        public ImageCacheParams(Context context, String diskCacheDirectoryName) {
            this.diskCacheDir = ImageCache.getDiskCacheDir(context, diskCacheDirectoryName);
        }

        public void setMemCacheSizePercent(float percent) {
            if (percent < 0.01f || percent > 0.8f) {
                throw new IllegalArgumentException("setMemCacheSizePercent - percent must be between 0.01 and 0.8 (inclusive)");
            }
            this.memCacheSize = Math.round(percent * (float)Runtime.getRuntime().maxMemory() / 1024.0f);
        }
    }
}

