/*
 * Decompiled with CFR 0.152.
 */
package nl.changer.polypicker.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import nl.changer.polypicker.utils.DiskLruCache;
import nl.changer.polypicker.utils.ImageCache;
import nl.changer.polypicker.utils.ImageResizer;

public class ImageFetcher
extends ImageResizer {
    private static final String TAG = "ImageFetcher";
    private static final int HTTP_CACHE_SIZE = 0xA00000;
    private static final String HTTP_CACHE_DIR = "http";
    private static final int IO_BUFFER_SIZE = 8192;
    private DiskLruCache mHttpDiskCache;
    private File mHttpCacheDir;
    private boolean mHttpDiskCacheStarting = true;
    private final Object mHttpDiskCacheLock = new Object();
    private static final int DISK_CACHE_INDEX = 0;

    public ImageFetcher(Context context, int imageWidth, int imageHeight) {
        super(context, imageWidth, imageHeight);
        this.init(context);
    }

    public ImageFetcher(Context context, int imageSize) {
        super(context, imageSize);
        this.init(context);
    }

    private void init(Context context) {
        this.checkConnection(context);
        this.mHttpCacheDir = ImageCache.getDiskCacheDir(context, HTTP_CACHE_DIR);
    }

    @Override
    protected void initDiskCacheInternal() {
        super.initDiskCacheInternal();
        this.initHttpDiskCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHttpDiskCache() {
        if (!this.mHttpCacheDir.exists()) {
            this.mHttpCacheDir.mkdirs();
        }
        Object object = this.mHttpDiskCacheLock;
        synchronized (object) {
            if (ImageCache.getUsableSpace(this.mHttpCacheDir) > 0xA00000L) {
                try {
                    this.mHttpDiskCache = DiskLruCache.open(this.mHttpCacheDir, 1, 1, 0xA00000L);
                }
                catch (IOException e) {
                    this.mHttpDiskCache = null;
                }
            }
            this.mHttpDiskCacheStarting = false;
            this.mHttpDiskCacheLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearCacheInternal() {
        super.clearCacheInternal();
        Object object = this.mHttpDiskCacheLock;
        synchronized (object) {
            if (this.mHttpDiskCache != null && !this.mHttpDiskCache.isClosed()) {
                try {
                    this.mHttpDiskCache.delete();
                    Log.d((String)TAG, (String)"HTTP cache cleared");
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("clearCacheInternal - " + e));
                }
                this.mHttpDiskCache = null;
                this.mHttpDiskCacheStarting = true;
                this.initHttpDiskCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushCacheInternal() {
        super.flushCacheInternal();
        Object object = this.mHttpDiskCacheLock;
        synchronized (object) {
            if (this.mHttpDiskCache != null) {
                try {
                    this.mHttpDiskCache.flush();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("flush - " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeCacheInternal() {
        super.closeCacheInternal();
        Object object = this.mHttpDiskCacheLock;
        synchronized (object) {
            if (this.mHttpDiskCache != null) {
                try {
                    if (!this.mHttpDiskCache.isClosed()) {
                        this.mHttpDiskCache.close();
                        this.mHttpDiskCache = null;
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("closeCacheInternal - " + e));
                }
            }
        }
    }

    private void checkConnection(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnectedOrConnecting()) {
            Log.e((String)TAG, (String)"checkConnection - no connection found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap processBitmap(String data) {
        String key = ImageCache.hashKeyForDisk(data);
        FileDescriptor fileDescriptor = null;
        FileInputStream fileInputStream = null;
        Object object = this.mHttpDiskCacheLock;
        synchronized (object) {
            while (this.mHttpDiskCacheStarting) {
                try {
                    this.mHttpDiskCacheLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.mHttpDiskCache != null) {
                try {
                    DiskLruCache.Snapshot snapshot = this.mHttpDiskCache.get(key);
                    if (snapshot == null) {
                        DiskLruCache.Editor editor = this.mHttpDiskCache.edit(key);
                        if (editor != null) {
                            if (this.downloadUrlToStream(data, editor.newOutputStream(0))) {
                                editor.commit();
                            } else {
                                editor.abort();
                            }
                        }
                        snapshot = this.mHttpDiskCache.get(key);
                    }
                    if (snapshot != null) {
                        fileInputStream = (FileInputStream)snapshot.getInputStream(0);
                        fileDescriptor = fileInputStream.getFD();
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("processBitmap - " + e));
                }
                catch (IllegalStateException e) {
                    Log.e((String)TAG, (String)("processBitmap - " + e));
                }
                finally {
                    if (fileDescriptor == null && fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        Bitmap bitmap = null;
        if (fileDescriptor != null) {
            bitmap = ImageFetcher.decodeSampledBitmapFromDescriptor(fileDescriptor, this.mImageWidth, this.mImageHeight, this.getImageCache());
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bitmap;
    }

    @Override
    protected Bitmap processBitmap(Object data) {
        return this.processBitmap(String.valueOf(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadUrlToStream(String urlString, OutputStream outputStream) {
        ImageFetcher.disableConnectionReuseIfNecessary();
        HttpURLConnection urlConnection = null;
        FilterOutputStream out = null;
        BufferedInputStream in = null;
        try {
            int b;
            URL url = new URL(urlString);
            urlConnection = (HttpURLConnection)url.openConnection();
            in = new BufferedInputStream(urlConnection.getInputStream(), 8192);
            out = new BufferedOutputStream(outputStream, 8192);
            while ((b = in.read()) != -1) {
                ((BufferedOutputStream)out).write(b);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error in downloadBitmap - " + e));
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void disableConnectionReuseIfNecessary() {
        if (Build.VERSION.SDK_INT < 8) {
            System.setProperty("http.keepAlive", "false");
        }
    }
}

