/*
 * Decompiled with CFR 0.152.
 */
package nl.changer.polypicker.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.InputStream;
import nl.changer.polypicker.utils.ImageCache;
import nl.changer.polypicker.utils.ImageWorker;
import nl.changer.polypicker.utils.Utils;

public class ImageResizer
extends ImageWorker {
    private static final String TAG = "ImageResizer";
    protected int mImageWidth;
    protected int mImageHeight;

    public ImageResizer(Context context, int imageWidth, int imageHeight) {
        super(context);
        this.setImageSize(imageWidth, imageHeight);
    }

    public ImageResizer(Context context, int imageSize) {
        super(context);
        this.setImageSize(imageSize);
    }

    public void setImageSize(int width, int height) {
        this.mImageWidth = width;
        this.mImageHeight = height;
    }

    public void setImageSize(int size) {
        this.setImageSize(size, size);
    }

    private Bitmap processBitmap(int resId) {
        return ImageResizer.decodeSampledBitmapFromResource(this.mResources, resId, this.mImageWidth, this.mImageHeight, this.getImageCache());
    }

    @Override
    protected Bitmap processBitmap(Object data) {
        return this.processBitmap(Integer.parseInt(String.valueOf(data)));
    }

    public static Bitmap decodeSampledBitmapFromResource(Resources res, int resId, int reqWidth, int reqHeight, ImageCache cache) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
        options.inSampleSize = ImageResizer.calculateInSampleSize(options, reqWidth, reqHeight);
        if (Utils.hasHoneycomb()) {
            ImageResizer.addInBitmapOptions(options, cache);
        }
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
    }

    public static Bitmap decodeSampledBitmapFromFile(String filename, int reqWidth, int reqHeight, ImageCache cache) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)options);
        options.inSampleSize = ImageResizer.calculateInSampleSize(options, reqWidth, reqHeight);
        if (Utils.hasHoneycomb()) {
            ImageResizer.addInBitmapOptions(options, cache);
        }
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)options);
    }

    public static Bitmap decodeSampledBitmapFromUri(Context context, Uri fileuri, int reqWidth, int reqHeight, ImageCache cache) {
        Bitmap bm = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(fileuri), null, (BitmapFactory.Options)options);
            options.inSampleSize = ImageResizer.calculateInSampleSize(options, reqWidth, reqHeight);
            options.inJustDecodeBounds = false;
            bm = BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(fileuri), null, (BitmapFactory.Options)options);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return bm;
    }

    public static Bitmap decodeSampledBitmapFromDescriptor(FileDescriptor fileDescriptor, int reqWidth, int reqHeight, ImageCache cache) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        options.inSampleSize = ImageResizer.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        if (Utils.hasHoneycomb()) {
            ImageResizer.addInBitmapOptions(options, cache);
        }
        return BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
    }

    @TargetApi(value=11)
    private static void addInBitmapOptions(BitmapFactory.Options options, ImageCache cache) {
        Bitmap inBitmap;
        options.inMutable = true;
        if (cache != null && (inBitmap = cache.getBitmapFromReusableSet(options)) != null) {
            options.inBitmap = inBitmap;
        }
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize > reqHeight && halfWidth / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
            long totalReqPixelsCap = reqWidth * reqHeight * 2;
            for (long totalPixels = (long)(width * height / inSampleSize); totalPixels > totalReqPixelsCap; totalPixels /= 2L) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }
}

