/*
 * Decompiled with CFR 0.152.
 */
package nl.changer.polypicker.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.widget.ImageView;
import java.lang.ref.WeakReference;
import nl.changer.polypicker.utils.AsyncTask;
import nl.changer.polypicker.utils.ImageCache;
import nl.changer.polypicker.utils.RecyclingBitmapDrawable;
import nl.changer.polypicker.utils.Utils;

public abstract class ImageWorker {
    private static final String TAG = "ImageWorker";
    private static final int FADE_IN_TIME = 200;
    private ImageCache mImageCache;
    private ImageCache.ImageCacheParams mImageCacheParams;
    private Bitmap mLoadingBitmap;
    private boolean mFadeInBitmap = true;
    private boolean mExitTasksEarly = false;
    protected boolean mPauseWork = false;
    private final Object mPauseWorkLock = new Object();
    protected Resources mResources;
    private static final int MESSAGE_CLEAR = 0;
    private static final int MESSAGE_INIT_DISK_CACHE = 1;
    private static final int MESSAGE_FLUSH = 2;
    private static final int MESSAGE_CLOSE = 3;

    protected ImageWorker(Context context) {
        this.mResources = context.getResources();
    }

    public void loadImage(Object data, ImageView imageView) {
        if (data == null) {
            return;
        }
        BitmapDrawable value = null;
        if (this.mImageCache != null) {
            value = this.mImageCache.getBitmapFromMemCache(String.valueOf(data));
        }
        if (value != null) {
            imageView.setImageDrawable(value);
        } else if (ImageWorker.cancelPotentialWork(data, imageView)) {
            BitmapWorkerTask task = new BitmapWorkerTask(data, imageView);
            AsyncDrawable asyncDrawable = new AsyncDrawable(this.mResources, this.mLoadingBitmap, task);
            imageView.setImageDrawable((Drawable)asyncDrawable);
            task.executeOnExecutor(AsyncTask.DUAL_THREAD_EXECUTOR, new Void[0]);
        }
    }

    public void setLoadingImage(Bitmap bitmap) {
        this.mLoadingBitmap = bitmap;
    }

    public void setLoadingImage(int resId) {
        this.mLoadingBitmap = BitmapFactory.decodeResource((Resources)this.mResources, (int)resId);
    }

    public void addImageCache(FragmentManager fragmentManager, ImageCache.ImageCacheParams cacheParams) {
        this.mImageCacheParams = cacheParams;
        this.mImageCache = ImageCache.getInstance(fragmentManager, this.mImageCacheParams);
        new CacheAsyncTask().execute(1);
    }

    public void addImageCache(FragmentActivity activity, String diskCacheDirectoryName) {
        this.mImageCacheParams = new ImageCache.ImageCacheParams((Context)activity, diskCacheDirectoryName);
        this.mImageCache = ImageCache.getInstance(activity.getSupportFragmentManager(), this.mImageCacheParams);
        new CacheAsyncTask().execute(1);
    }

    public void setImageFadeIn(boolean fadeIn) {
        this.mFadeInBitmap = fadeIn;
    }

    public void setExitTasksEarly(boolean exitTasksEarly) {
        this.mExitTasksEarly = exitTasksEarly;
        this.setPauseWork(false);
    }

    protected abstract Bitmap processBitmap(Object var1);

    protected ImageCache getImageCache() {
        return this.mImageCache;
    }

    public static void cancelWork(ImageView imageView) {
        BitmapWorkerTask bitmapWorkerTask = ImageWorker.getBitmapWorkerTask(imageView);
        if (bitmapWorkerTask != null) {
            bitmapWorkerTask.cancel(true);
        }
    }

    public static boolean cancelPotentialWork(Object data, ImageView imageView) {
        BitmapWorkerTask bitmapWorkerTask = ImageWorker.getBitmapWorkerTask(imageView);
        if (bitmapWorkerTask != null) {
            Object bitmapData = bitmapWorkerTask.mData;
            if (bitmapData == null || !bitmapData.equals(data)) {
                bitmapWorkerTask.cancel(true);
            } else {
                return false;
            }
        }
        return true;
    }

    private static BitmapWorkerTask getBitmapWorkerTask(ImageView imageView) {
        Drawable drawable2;
        if (imageView != null && (drawable2 = imageView.getDrawable()) instanceof AsyncDrawable) {
            AsyncDrawable asyncDrawable = (AsyncDrawable)drawable2;
            return asyncDrawable.getBitmapWorkerTask();
        }
        return null;
    }

    private void setImageDrawable(ImageView imageView, Drawable drawable2) {
        if (this.mFadeInBitmap) {
            TransitionDrawable td = new TransitionDrawable(new Drawable[]{new ColorDrawable(17170445), drawable2});
            imageView.setBackgroundDrawable((Drawable)new BitmapDrawable(this.mResources, this.mLoadingBitmap));
            imageView.setImageDrawable((Drawable)td);
            td.startTransition(200);
        } else {
            imageView.setImageDrawable(drawable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPauseWork(boolean pauseWork) {
        Object object = this.mPauseWorkLock;
        synchronized (object) {
            this.mPauseWork = pauseWork;
            if (!this.mPauseWork) {
                this.mPauseWorkLock.notifyAll();
            }
        }
    }

    protected void initDiskCacheInternal() {
        if (this.mImageCache != null) {
            this.mImageCache.initDiskCache();
        }
    }

    protected void clearCacheInternal() {
        if (this.mImageCache != null) {
            this.mImageCache.clearCache();
        }
    }

    protected void flushCacheInternal() {
        if (this.mImageCache != null) {
            this.mImageCache.flush();
        }
    }

    protected void closeCacheInternal() {
        if (this.mImageCache != null) {
            this.mImageCache.close();
            this.mImageCache = null;
        }
    }

    public void clearCache() {
        new CacheAsyncTask().execute(0);
    }

    public void flushCache() {
        new CacheAsyncTask().execute(2);
    }

    public void closeCache() {
        new CacheAsyncTask().execute(3);
    }

    protected class CacheAsyncTask
    extends AsyncTask<Object, Void, Void> {
        protected CacheAsyncTask() {
        }

        @Override
        protected Void doInBackground(Object ... params) {
            switch ((Integer)params[0]) {
                case 0: {
                    ImageWorker.this.clearCacheInternal();
                    break;
                }
                case 1: {
                    ImageWorker.this.initDiskCacheInternal();
                    break;
                }
                case 2: {
                    ImageWorker.this.flushCacheInternal();
                    break;
                }
                case 3: {
                    ImageWorker.this.closeCacheInternal();
                }
            }
            return null;
        }
    }

    private static class AsyncDrawable
    extends BitmapDrawable {
        private final WeakReference<BitmapWorkerTask> bitmapWorkerTaskReference;

        public AsyncDrawable(Resources res, Bitmap bitmap, BitmapWorkerTask bitmapWorkerTask) {
            super(res, bitmap);
            this.bitmapWorkerTaskReference = new WeakReference<BitmapWorkerTask>(bitmapWorkerTask);
        }

        public BitmapWorkerTask getBitmapWorkerTask() {
            return (BitmapWorkerTask)this.bitmapWorkerTaskReference.get();
        }
    }

    private class BitmapWorkerTask
    extends AsyncTask<Void, Void, BitmapDrawable> {
        private Object mData;
        private final WeakReference<ImageView> imageViewReference;

        public BitmapWorkerTask(Object data, ImageView imageView) {
            this.mData = data;
            this.imageViewReference = new WeakReference<ImageView>(imageView);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected BitmapDrawable doInBackground(Void ... params) {
            String dataString = String.valueOf(this.mData);
            Bitmap bitmap = null;
            Object drawable2 = null;
            Object object = ImageWorker.this.mPauseWorkLock;
            synchronized (object) {
                while (ImageWorker.this.mPauseWork && !this.isCancelled()) {
                    try {
                        ImageWorker.this.mPauseWorkLock.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            if (ImageWorker.this.mImageCache != null && !this.isCancelled() && this.getAttachedImageView() != null && !ImageWorker.this.mExitTasksEarly) {
                bitmap = ImageWorker.this.mImageCache.getBitmapFromDiskCache(dataString);
            }
            if (bitmap == null && !this.isCancelled() && this.getAttachedImageView() != null && !ImageWorker.this.mExitTasksEarly) {
                bitmap = ImageWorker.this.processBitmap(this.mData);
            }
            if (bitmap != null) {
                drawable2 = Utils.hasHoneycomb() ? new BitmapDrawable(ImageWorker.this.mResources, bitmap) : new RecyclingBitmapDrawable(ImageWorker.this.mResources, bitmap);
                if (ImageWorker.this.mImageCache != null) {
                    ImageWorker.this.mImageCache.addBitmapToCache(dataString, (BitmapDrawable)drawable2);
                }
            }
            return drawable2;
        }

        @Override
        protected void onPostExecute(BitmapDrawable value) {
            if (this.isCancelled() || ImageWorker.this.mExitTasksEarly) {
                value = null;
            }
            ImageView imageView = this.getAttachedImageView();
            if (value != null && imageView != null) {
                ImageWorker.this.setImageDrawable(imageView, (Drawable)value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCancelled(BitmapDrawable value) {
            super.onCancelled(value);
            Object object = ImageWorker.this.mPauseWorkLock;
            synchronized (object) {
                ImageWorker.this.mPauseWorkLock.notifyAll();
            }
        }

        private ImageView getAttachedImageView() {
            ImageView imageView = (ImageView)this.imageViewReference.get();
            BitmapWorkerTask bitmapWorkerTask = ImageWorker.getBitmapWorkerTask(imageView);
            if (this == bitmapWorkerTask) {
                return imageView;
            }
            return null;
        }
    }
}

