/*
 * Decompiled with CFR 0.152.
 */
package nl.changer.polypicker.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;

public class RecyclingBitmapDrawable
extends BitmapDrawable {
    static final String TAG = "CountingBitmapDrawable";
    private int mCacheRefCount = 0;
    private int mDisplayRefCount = 0;
    private boolean mHasBeenDisplayed;

    public RecyclingBitmapDrawable(Resources res, Bitmap bitmap) {
        super(res, bitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsDisplayed(boolean isDisplayed) {
        RecyclingBitmapDrawable recyclingBitmapDrawable = this;
        synchronized (recyclingBitmapDrawable) {
            if (isDisplayed) {
                ++this.mDisplayRefCount;
                this.mHasBeenDisplayed = true;
            } else {
                --this.mDisplayRefCount;
            }
        }
        this.checkState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsCached(boolean isCached) {
        RecyclingBitmapDrawable recyclingBitmapDrawable = this;
        synchronized (recyclingBitmapDrawable) {
            this.mCacheRefCount = isCached ? ++this.mCacheRefCount : --this.mCacheRefCount;
        }
        this.checkState();
    }

    private synchronized void checkState() {
        if (this.mCacheRefCount <= 0 && this.mDisplayRefCount <= 0 && this.mHasBeenDisplayed && this.hasValidBitmap()) {
            this.getBitmap().recycle();
        }
    }

    private synchronized boolean hasValidBitmap() {
        Bitmap bitmap = this.getBitmap();
        return bitmap != null && !bitmap.isRecycled();
    }
}

