/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.operators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;
import java.util.Map;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.misc.Strings;
import net.thisptr.jackson.jq.internal.operators.BinaryOperator;

public class MultiplyOperator
implements BinaryOperator {
    @Override
    public JsonNode apply(ObjectMapper mapper, JsonNode lhs, JsonNode rhs) throws JsonQueryException {
        if (lhs.isIntegralNumber() && rhs.isIntegralNumber()) {
            long r = lhs.asLong() * rhs.asLong();
            return JsonNodeUtils.asNumericNode(r);
        }
        if (lhs.isNumber() && rhs.isNumber()) {
            double r = lhs.asDouble() * rhs.asDouble();
            return JsonNodeUtils.asNumericNode(r);
        }
        if (lhs.isTextual() && rhs.isNumber()) {
            double count = rhs.asDouble();
            if (count <= 0.0) {
                return NullNode.getInstance();
            }
            if (count < 2.0) {
                return lhs;
            }
            return new TextNode(Strings.repeat(lhs.asText(), (int)count));
        }
        if (lhs.isNumber() && rhs.isTextual()) {
            double count = lhs.asDouble();
            if (count <= 0.0) {
                return NullNode.getInstance();
            }
            if (count < 2.0) {
                return rhs;
            }
            return new TextNode(Strings.repeat(rhs.asText(), (int)count));
        }
        if (lhs.isObject() && rhs.isObject()) {
            return MultiplyOperator.mergeRecursive(mapper, (ObjectNode)lhs, (ObjectNode)rhs);
        }
        throw new JsonQueryTypeException("%s and %s cannot be multiplied", lhs, rhs);
    }

    private static ObjectNode mergeRecursive(ObjectMapper mapper, ObjectNode lhs, ObjectNode rhs) {
        ObjectNode result = mapper.createObjectNode();
        Iterator<Map.Entry<String, JsonNode>> liter = lhs.fields();
        while (liter.hasNext()) {
            Map.Entry<String, JsonNode> e = liter.next();
            result.set(e.getKey(), e.getValue());
        }
        Iterator<Map.Entry<String, JsonNode>> riter = rhs.fields();
        while (riter.hasNext()) {
            JsonNode r;
            Map.Entry<String, JsonNode> e = riter.next();
            JsonNode l = result.get(e.getKey());
            JsonNode resolved = r = e.getValue();
            if (l != null && l.isObject() && r.isObject()) {
                resolved = MultiplyOperator.mergeRecursive(mapper, (ObjectNode)l, (ObjectNode)r);
            }
            result.set(e.getKey(), resolved);
        }
        return result;
    }

    @Override
    public String image() {
        return "*";
    }
}

