/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.List;
import java.util.Stack;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.Pair;
import net.thisptr.jackson.jq.path.Path;

public class StringInterpolation
implements Expression {
    private final List<Pair<Integer, Expression>> interpolations;
    private final String template;
    private final Expression formatter;

    public StringInterpolation(String template, List<Pair<Integer, Expression>> interpolations, Expression formatter) {
        this.template = template;
        this.interpolations = interpolations;
        this.formatter = formatter;
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path ipath, PathOutput output, boolean requirePath) throws JsonQueryException {
        Stack<Pair<Integer, JsonNode>> stack = new Stack<Pair<Integer, JsonNode>>();
        this.recurse(scope, in, output, stack, this.interpolations);
    }

    private void recurse(Scope scope, JsonNode in, PathOutput output, Stack<Pair<Integer, JsonNode>> stack, List<Pair<Integer, Expression>> interpolations) throws JsonQueryException {
        if (interpolations.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            int pos = 0;
            for (int index = stack.size() - 1; index >= 0; --index) {
                Pair head = (Pair)stack.get(index);
                builder.append(this.template.substring(pos, (Integer)head._1));
                pos = (Integer)head._1;
                builder.append(((JsonNode)head._2).isValueNode() ? ((JsonNode)head._2).asText() : ((JsonNode)head._2).toString());
            }
            builder.append(this.template.substring(pos));
            output.emit(new TextNode(builder.toString()), null);
        } else {
            Pair<Integer, Expression> rhead = interpolations.get(interpolations.size() - 1);
            List<Pair<Integer, Expression>> rtail = interpolations.subList(0, interpolations.size() - 1);
            ((Expression)rhead._2).apply(scope, in, interpolated -> {
                if (this.formatter != null) {
                    this.formatter.apply(scope, interpolated, formatted -> {
                        stack.push(Pair.of(rhead._1, formatted));
                        this.recurse(scope, in, output, stack, rtail);
                        stack.pop();
                    });
                } else {
                    stack.push(Pair.of(rhead._1, interpolated));
                    this.recurse(scope, in, output, stack, rtail);
                    stack.pop();
                }
            });
        }
    }

    public String toString() {
        int pos = 0;
        StringBuilder builder = new StringBuilder();
        if (this.formatter != null) {
            builder.append(this.formatter);
            builder.append(" ");
        }
        builder.append("\"");
        for (Pair<Integer, Expression> interpolation : this.interpolations) {
            StringInterpolation.copyEscaped(builder, this.template, pos, (Integer)interpolation._1);
            pos = (Integer)interpolation._1;
            builder.append("\\(");
            builder.append(interpolation._2);
            builder.append(")");
        }
        StringInterpolation.copyEscaped(builder, this.template, pos, this.template.length());
        builder.append("\"");
        return builder.toString();
    }

    private static void copyEscaped(StringBuilder builder, String text, int begin, int end) {
        block9: for (int i = begin; i < end; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\\': {
                    builder.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    builder.append("\\\"");
                    continue block9;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block9;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block9;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block9;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block9;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block9;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
    }
}

