/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.extra.functions;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.auto.service.AutoService;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.Preconditions;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"uriparse/0"})
@AutoService(value={Function.class})
public class UriParseFunction
implements Function {
    private static final Pattern AMPERSAND = Pattern.compile(Pattern.quote("&"));
    private static final Pattern EQUAL = Pattern.compile(Pattern.quote("="));

    private Map<String, JsonNode> parseQueryObj(Scope scope, String rawQuery) {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        if (rawQuery == null) {
            return Collections.emptyMap();
        }
        for (String kv : AMPERSAND.split(rawQuery, -1)) {
            String[] tuple = EQUAL.split(kv, -1);
            if (tuple.length != 2) continue;
            String keyEncoded = tuple[0];
            String valueEncoded = tuple[1];
            try {
                String key = URLDecoder.decode(keyEncoded, "UTF-8");
                String value = URLDecoder.decode(valueEncoded, "UTF-8");
                ArrayList<String> arr = (ArrayList<String>)result.get(key);
                if (arr == null) {
                    arr = new ArrayList<String>(1);
                    result.put(key, arr);
                }
                arr.add(value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        HashMap<String, JsonNode> result2 = new HashMap<String, JsonNode>();
        for (Map.Entry entry : result.entrySet()) {
            if (((List)entry.getValue()).size() > 1) {
                ArrayNode arr = scope.getObjectMapper().createArrayNode();
                for (String value : (List)entry.getValue()) {
                    arr.add((JsonNode)new TextNode(value));
                }
                result2.put((String)entry.getKey(), (JsonNode)arr);
                continue;
            }
            result2.put((String)entry.getKey(), (JsonNode)new TextNode((String)((List)entry.getValue()).get(0)));
        }
        return result2;
    }

    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        Preconditions.checkInputType((String)"uriparse", (JsonNode)in, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.STRING});
        try {
            URI uri = new URI(in.asText());
            Result result = new Result(uri, this.parseQueryObj(scope, uri.getRawQuery()));
            output.emit(scope.getObjectMapper().valueToTree((Object)result), null);
        }
        catch (URISyntaxException e) {
            throw new JsonQueryException((Throwable)e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Result {
        @JsonProperty(value="scheme")
        public String scheme;
        @JsonProperty(value="user_info")
        private String userInfo;
        @JsonProperty(value="raw_user_info")
        private String rawUserInfo;
        @JsonProperty(value="host")
        private String host;
        @JsonProperty(value="port")
        public int port;
        @JsonProperty(value="authority")
        private String authority;
        @JsonProperty(value="raw_authority")
        private String rawAuthority;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="raw_path")
        private String rawPath;
        @JsonProperty(value="query")
        private String query;
        @JsonProperty(value="raw_query")
        private String rawQuery;
        @JsonProperty(value="query_obj")
        private Map<String, JsonNode> queryObj;
        @JsonProperty(value="fragment")
        private String fragment;
        @JsonProperty(value="raw_fragment")
        private String rawFragment;

        public Result(URI uri, Map<String, JsonNode> queryObj) {
            this.port = uri.getPort();
            this.scheme = uri.getScheme();
            this.host = uri.getHost();
            this.path = uri.getPath();
            this.fragment = uri.getFragment();
            this.authority = uri.getAuthority();
            this.query = uri.getQuery();
            this.userInfo = uri.getUserInfo();
            this.rawQuery = uri.getRawQuery();
            this.queryObj = queryObj;
            this.rawUserInfo = uri.getRawUserInfo();
            this.rawAuthority = uri.getRawAuthority();
            this.rawFragment = uri.getRawFragment();
            this.rawPath = uri.getRawPath();
        }
    }
}

