/* JsonQueryParser.java */
/* Generated By:JavaCC: Do not edit this line. JsonQueryParser.java */
        package net.thisptr.jackson.jq.internal.javacc;

        import java.io.StringReader;
        import java.util.List;
        import java.util.Stack;
        import java.util.ArrayList;

        import net.thisptr.jackson.jq.JsonQuery;
        import net.thisptr.jackson.jq.internal.misc.Pair;
        import net.thisptr.jackson.jq.internal.tree.*;
        import net.thisptr.jackson.jq.internal.tree.binaryop.*;
        import net.thisptr.jackson.jq.internal.tree.literal.*;
        import net.thisptr.jackson.jq.internal.tree.fieldaccess.*;
        import net.thisptr.jackson.jq.internal.tree.matcher.*;
        import net.thisptr.jackson.jq.internal.tree.matcher.matchers.*;

        @SuppressWarnings("unused")
        public class JsonQueryParser implements JsonQueryParserConstants {
                public static JsonQuery compile(final String line) throws ParseException {
                        final JsonQueryParser parser = new JsonQueryParser(new StringReader(line));
                        return parser.Start();
                }

  final public String KeywordAsString() throws ParseException {Token token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case KEYWORD_IF:{
      token = jj_consume_token(KEYWORD_IF);
      break;
      }
    case KEYWORD_THEN:{
      token = jj_consume_token(KEYWORD_THEN);
      break;
      }
    case KEYWORD_ELIF:{
      token = jj_consume_token(KEYWORD_ELIF);
      break;
      }
    case KEYWORD_ELSE:{
      token = jj_consume_token(KEYWORD_ELSE);
      break;
      }
    case KEYWORD_END:{
      token = jj_consume_token(KEYWORD_END);
      break;
      }
    case KEYWORD_AS:{
      token = jj_consume_token(KEYWORD_AS);
      break;
      }
    case KEYWORD_DEF:{
      token = jj_consume_token(KEYWORD_DEF);
      break;
      }
    case BOOLEAN_LITERAL_TRUE:{
      token = jj_consume_token(BOOLEAN_LITERAL_TRUE);
      break;
      }
    case BOOLEAN_LITERAL_FALSE:{
      token = jj_consume_token(BOOLEAN_LITERAL_FALSE);
      break;
      }
    case OP_AND:{
      token = jj_consume_token(OP_AND);
      break;
      }
    case OP_OR:{
      token = jj_consume_token(OP_OR);
      break;
      }
    case NULL_LITERAL:{
      token = jj_consume_token(NULL_LITERAL);
      break;
      }
    case KEYWORD_REDUCE:{
      token = jj_consume_token(KEYWORD_REDUCE);
      break;
      }
    case KEYWORD_FOREACH:{
      token = jj_consume_token(KEYWORD_FOREACH);
      break;
      }
    case KEYWORD_TRY:{
      token = jj_consume_token(KEYWORD_TRY);
      break;
      }
    case KEYWORD_CATCH:{
      token = jj_consume_token(KEYWORD_CATCH);
      break;
      }
    case KEYWORD_LABEL:{
      token = jj_consume_token(KEYWORD_LABEL);
      break;
      }
    case KEYWORD_IMPORT:{
      token = jj_consume_token(KEYWORD_IMPORT);
      break;
      }
    case KEYWORD_INCLUDE:{
      token = jj_consume_token(KEYWORD_INCLUDE);
      break;
      }
    case KEYWORD_MODULE:{
      token = jj_consume_token(KEYWORD_MODULE);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return token.image;}
    throw new Error("Missing return statement in function");
  }

  final public String IdentifierAsString() throws ParseException {Token token;
    token = jj_consume_token(IDENTIFIER);
{if ("" != null) return token.image;}
    throw new Error("Missing return statement in function");
  }

  final public String KeywordOrIdentifier() throws ParseException {String text;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OP_AND:
    case OP_OR:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case KEYWORD_IF:
    case KEYWORD_THEN:
    case KEYWORD_ELIF:
    case KEYWORD_ELSE:
    case KEYWORD_END:
    case KEYWORD_AS:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_CATCH:
    case KEYWORD_LABEL:
    case KEYWORD_IMPORT:
    case KEYWORD_INCLUDE:
    case KEYWORD_MODULE:{
      text = KeywordAsString();
      break;
      }
    case IDENTIFIER:{
      text = IdentifierAsString();
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return text;}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery Start() throws ParseException {JsonQuery q;
    q = JsonQuery();
    jj_consume_token(0);
{if ("" != null) return q;}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery JsonQuery() throws ParseException {JsonQuery expr;
        PatternMatcher matcher;
        final List<Pair<JsonQuery, PatternMatcher>> qs = new ArrayList<Pair<JsonQuery, PatternMatcher>>();
    expr = TupleExpression();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PIPE:
      case KEYWORD_AS:{
        ;
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case KEYWORD_AS:{
        jj_consume_token(KEYWORD_AS);
        matcher = Matcher();
        break;
        }
      default:
        jj_la1[3] = jj_gen;
matcher = null;
      }
      jj_consume_token(PIPE);
qs.add(Pair.<JsonQuery, PatternMatcher> of(expr, matcher));
      expr = TupleExpression();
    }
qs.add(Pair.<JsonQuery, PatternMatcher> of(expr, null));
if (qs.size() == 1)
                        {if ("" != null) return qs.get(0)._1;}
                {if ("" != null) return new PipedQuery(qs);}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery JsonQueryWithoutComma() throws ParseException {JsonQuery expr;
        PatternMatcher matcher;
        final List<Pair<JsonQuery, PatternMatcher>> qs = new ArrayList<Pair<JsonQuery, PatternMatcher>>();
    expr = BinaryOperatorExpression();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PIPE:
      case KEYWORD_AS:{
        ;
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        break label_2;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case KEYWORD_AS:{
        jj_consume_token(KEYWORD_AS);
        matcher = Matcher();
        break;
        }
      default:
        jj_la1[5] = jj_gen;
matcher = null;
      }
      jj_consume_token(PIPE);
qs.add(Pair.<JsonQuery, PatternMatcher> of(expr, matcher));
      expr = BinaryOperatorExpression();
    }
qs.add(Pair.<JsonQuery, PatternMatcher> of(expr, null));
if (qs.size() == 1)
                        {if ("" != null) return qs.get(0)._1;}
                {if ("" != null) return new PipedQuery(qs);}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery TupleExpression() throws ParseException {JsonQuery tmp;
        final List<JsonQuery> qs = new ArrayList<JsonQuery>();
    tmp = BinaryOperatorExpression();
qs.add(tmp);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
      tmp = BinaryOperatorExpression();
qs.add(tmp);
    }
if (qs.size() == 1)
                        {if ("" != null) return qs.get(0);}
                {if ("" != null) return new Tuple(qs);}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery BinaryOperatorExpression() throws ParseException {Token t;
        JsonQuery expr;
        List<JsonQuery> exprs = new ArrayList<JsonQuery>();
        List<BinaryOperatorExpression.Operator> operators = new ArrayList<BinaryOperatorExpression.Operator>();
    expr = PrimaryExpression();
exprs.add(expr);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OP_AND:
      case OP_OR:
      case OP_DEFAULT:
      case COMP_EQUAL:
      case COMP_NOT_EQUAL:
      case COMP_GREATER:
      case COMP_GREATER_EQUAL:
      case COMP_LESS:
      case COMP_LESS_EQUAL:
      case PLUS:
      case MINUS:
      case TIMES:
      case DIVIDE:
      case MODULO:
      case ASSIGN_OP:
      case UPDATE_OP:
      case PLUS_EQUAL:
      case MINUS_EQUAL:
      case TIMES_EQUAL:
      case DIVIDE_EQUAL:
      case MODULO_EQUAL:
      case DEFAULT_EQUAL:{
        ;
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TIMES:{
        t = jj_consume_token(TIMES);
        break;
        }
      case DIVIDE:{
        t = jj_consume_token(DIVIDE);
        break;
        }
      case MODULO:{
        t = jj_consume_token(MODULO);
        break;
        }
      case PLUS:{
        t = jj_consume_token(PLUS);
        break;
        }
      case MINUS:{
        t = jj_consume_token(MINUS);
        break;
        }
      case COMP_EQUAL:{
        t = jj_consume_token(COMP_EQUAL);
        break;
        }
      case COMP_NOT_EQUAL:{
        t = jj_consume_token(COMP_NOT_EQUAL);
        break;
        }
      case COMP_GREATER:{
        t = jj_consume_token(COMP_GREATER);
        break;
        }
      case COMP_GREATER_EQUAL:{
        t = jj_consume_token(COMP_GREATER_EQUAL);
        break;
        }
      case COMP_LESS:{
        t = jj_consume_token(COMP_LESS);
        break;
        }
      case COMP_LESS_EQUAL:{
        t = jj_consume_token(COMP_LESS_EQUAL);
        break;
        }
      case OP_AND:{
        t = jj_consume_token(OP_AND);
        break;
        }
      case OP_OR:{
        t = jj_consume_token(OP_OR);
        break;
        }
      case OP_DEFAULT:{
        t = jj_consume_token(OP_DEFAULT);
        break;
        }
      case ASSIGN_OP:{
        t = jj_consume_token(ASSIGN_OP);
        break;
        }
      case UPDATE_OP:{
        t = jj_consume_token(UPDATE_OP);
        break;
        }
      case PLUS_EQUAL:{
        t = jj_consume_token(PLUS_EQUAL);
        break;
        }
      case MINUS_EQUAL:{
        t = jj_consume_token(MINUS_EQUAL);
        break;
        }
      case TIMES_EQUAL:{
        t = jj_consume_token(TIMES_EQUAL);
        break;
        }
      case DIVIDE_EQUAL:{
        t = jj_consume_token(DIVIDE_EQUAL);
        break;
        }
      case MODULO_EQUAL:{
        t = jj_consume_token(MODULO_EQUAL);
        break;
        }
      case DEFAULT_EQUAL:{
        t = jj_consume_token(DEFAULT_EQUAL);
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
operators.add(BinaryOperatorExpression.Operator.fromImage(t.image));
      expr = PrimaryExpression();
exprs.add(expr);
    }
{if ("" != null) return BinaryOperatorExpression.buildTree(exprs, operators);}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery FunctionDefinition() throws ParseException {final List<String> args = new ArrayList<String>();
        Token fname;
        String tmp;
        JsonQuery body;
    jj_consume_token(KEYWORD_DEF);
    fname = jj_consume_token(IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OPEN_PAR:{
      jj_consume_token(OPEN_PAR);
      tmp = FunctionDefinitionParam();
args.add(tmp);
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          break label_5;
        }
        jj_consume_token(SEMICOLON);
        tmp = FunctionDefinitionParam();
args.add(tmp);
      }
      jj_consume_token(CLOSE_PAR);
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      ;
    }
    jj_consume_token(COLON);
    body = JsonQuery();
    jj_consume_token(SEMICOLON);
{if ("" != null) return new FunctionDefinition(fname.image, args, body);}
    throw new Error("Missing return statement in function");
  }

  final public String FunctionDefinitionParam() throws ParseException {Token param;
        boolean isvar = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOLLAR:{
      jj_consume_token(DOLLAR);
isvar = true;
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    param = jj_consume_token(IDENTIFIER);
{if ("" != null) return (isvar ? "$" : "") + param.image;}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery PrimaryExpression() throws ParseException {Token t;
        JsonQuery tmp;
        List<JsonQuery> exprs = new ArrayList<JsonQuery>();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case KEYWORD_DEF:{
        ;
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        break label_6;
      }
      tmp = FunctionDefinition();
exprs.add(tmp);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOT:{
      tmp = ThisObjectAccess();
      break;
      }
    case DOLLAR:{
      tmp = VariableAccess();
      break;
      }
    case OPEN_BRACKET:
    case ATSIGN:
    case OPEN_BRACE:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case INTEGER_LITERAL:
    case FLOAT_LITERAL:
    case QUOTE:
    case IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BOOLEAN_LITERAL_TRUE:
      case BOOLEAN_LITERAL_FALSE:
      case NULL_LITERAL:
      case INTEGER_LITERAL:
      case FLOAT_LITERAL:{
        tmp = ValueLiteral();
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        if (jj_2_1(3)) {
          tmp = StringInterpolation();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ATSIGN:{
            tmp = FormattingFilter();
            break;
            }
          case OPEN_BRACKET:{
            tmp = ArrayConstruction();
            break;
            }
          case OPEN_BRACE:{
            tmp = ObjectConstruction();
            break;
            }
          case IDENTIFIER:{
            tmp = FunctionCall();
            break;
            }
          default:
            jj_la1[14] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:
      case OPEN_BRACKET:{
        tmp = FieldAccessor(tmp);
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        ;
      }
      break;
      }
    case OPEN_PAR:{
      jj_consume_token(OPEN_PAR);
      tmp = JsonQuery();
      jj_consume_token(CLOSE_PAR);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:
      case OPEN_BRACKET:{
        tmp = FieldAccessor(tmp);
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case QUESTION:{
        jj_consume_token(QUESTION);
tmp = new TryCatch.Question(tmp);
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        ;
      }
      break;
      }
    case MINUS:{
      jj_consume_token(MINUS);
      tmp = PrimaryExpression();
tmp = new NegativeExpression(tmp);
      break;
      }
    case KEYWORD_IF:{
      tmp = ConditionalExpression();
      break;
      }
    case KEYWORD_REDUCE:{
      tmp = ReduceExpression();
      break;
      }
    case RECURSION:{
      tmp = RecursionOperator();
      break;
      }
    case KEYWORD_FOREACH:{
      tmp = ForeachExpression();
      break;
      }
    case KEYWORD_TRY:{
      tmp = TryCatchExpression();
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
exprs.add(tmp);
                if (exprs.size() == 1)
                        {if ("" != null) return exprs.get(0);}
                {if ("" != null) return new SemicolonOperator(exprs);}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery RecursionOperator() throws ParseException {
    jj_consume_token(RECURSION);
{if ("" != null) return new RecursionOperator();}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery FormattingFilter() throws ParseException {Token t;
    jj_consume_token(ATSIGN);
    t = jj_consume_token(IDENTIFIER);
{if ("" != null) return new FormattingFilter(t.image);}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery TryCatchExpression() throws ParseException {JsonQuery tryExpr, catchExpr = null;
    jj_consume_token(KEYWORD_TRY);
    tryExpr = JsonQuery();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case KEYWORD_CATCH:{
      jj_consume_token(KEYWORD_CATCH);
      catchExpr = PrimaryExpression();
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
{if ("" != null) return new TryCatch(tryExpr, catchExpr);}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery ForeachExpression() throws ParseException {PatternMatcher matcher;
        JsonQuery initExpr, updateExpr, extractExpr = null, iterExpr;
    jj_consume_token(KEYWORD_FOREACH);
    iterExpr = PrimaryExpression();
    jj_consume_token(KEYWORD_AS);
    matcher = Matcher();
    jj_consume_token(OPEN_PAR);
    initExpr = JsonQuery();
    jj_consume_token(SEMICOLON);
    updateExpr = JsonQuery();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      extractExpr = JsonQuery();
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    jj_consume_token(CLOSE_PAR);
{if ("" != null) return new ForeachExpression(matcher, initExpr, updateExpr, extractExpr, iterExpr);}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery ReduceExpression() throws ParseException {PatternMatcher matcher;
        JsonQuery tmpIterExpr, tmpInitExpr, tmpReduceExpr;
    jj_consume_token(KEYWORD_REDUCE);
    tmpIterExpr = PrimaryExpression();
    jj_consume_token(KEYWORD_AS);
    matcher = Matcher();
    jj_consume_token(OPEN_PAR);
    tmpInitExpr = JsonQuery();
    jj_consume_token(SEMICOLON);
    tmpReduceExpr = JsonQuery();
    jj_consume_token(CLOSE_PAR);
{if ("" != null) return new ReduceExpression(matcher, tmpInitExpr, tmpReduceExpr, tmpIterExpr);}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery VariableAccess() throws ParseException {Token t;
        JsonQuery tmp;
    jj_consume_token(DOLLAR);
    t = jj_consume_token(IDENTIFIER);
tmp = new VariableAccess(t.image);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOT:
    case OPEN_BRACKET:{
      tmp = FieldAccessor(tmp);
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      ;
    }
{if ("" != null) return tmp;}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery ConditionalExpression() throws ParseException {JsonQuery tmpPred;
        JsonQuery tmpExpr;
        final List<Pair<JsonQuery, JsonQuery>> switches = new ArrayList<Pair<JsonQuery, JsonQuery>>();
        final JsonQuery otherwise;
    jj_consume_token(KEYWORD_IF);
    tmpPred = JsonQuery();
    jj_consume_token(KEYWORD_THEN);
    tmpExpr = JsonQuery();
switches.add(Pair.of(tmpPred, tmpExpr));
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case KEYWORD_ELIF:{
        ;
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        break label_7;
      }
      jj_consume_token(KEYWORD_ELIF);
      tmpPred = JsonQuery();
      jj_consume_token(KEYWORD_THEN);
      tmpExpr = JsonQuery();
switches.add(Pair.of(tmpPred, tmpExpr));
    }
    jj_consume_token(KEYWORD_ELSE);
    otherwise = JsonQuery();
    jj_consume_token(KEYWORD_END);
{if ("" != null) return new Conditional(switches, otherwise);}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery ObjectConstruction() throws ParseException {final ObjectConstruction obj = new ObjectConstruction();
    jj_consume_token(OPEN_BRACE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OP_AND:
    case OP_OR:
    case OPEN_PAR:
    case DOLLAR:
    case ATSIGN:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case QUOTE:
    case KEYWORD_IF:
    case KEYWORD_THEN:
    case KEYWORD_ELIF:
    case KEYWORD_ELSE:
    case KEYWORD_END:
    case KEYWORD_AS:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_CATCH:
    case KEYWORD_LABEL:
    case KEYWORD_IMPORT:
    case KEYWORD_INCLUDE:
    case KEYWORD_MODULE:
    case IDENTIFIER:{
      ObjectField(obj);
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[23] = jj_gen;
          break label_8;
        }
        jj_consume_token(COMMA);
        ObjectField(obj);
      }
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      ;
    }
    jj_consume_token(CLOSE_BRACE);
{if ("" != null) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public void ObjectField(final ObjectConstruction obj) throws ParseException {String name;
        JsonQuery value = null;
        JsonQuery key = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOLLAR:{
      jj_consume_token(DOLLAR);
      name = KeywordOrIdentifier();
obj.add(new VariableKeyFieldConstruction(name));
      break;
      }
    case OP_AND:
    case OP_OR:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case KEYWORD_IF:
    case KEYWORD_THEN:
    case KEYWORD_ELIF:
    case KEYWORD_ELSE:
    case KEYWORD_END:
    case KEYWORD_AS:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_CATCH:
    case KEYWORD_LABEL:
    case KEYWORD_IMPORT:
    case KEYWORD_INCLUDE:
    case KEYWORD_MODULE:
    case IDENTIFIER:{
      // {name}, {name: value}
                      name = KeywordOrIdentifier();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        value = ObjectFieldValue();
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        ;
      }
obj.add(new IdentifierKeyFieldConstruction(name, value));
      break;
      }
    case ATSIGN:
    case QUOTE:{
      // {"name"}, {"name": value}
                      key = StringInterpolation();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        value = ObjectFieldValue();
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        ;
      }
obj.add(new StringKeyFieldConstruction(key, value));
      break;
      }
    case OPEN_PAR:{
      jj_consume_token(OPEN_PAR);
      key = JsonQuery();
      jj_consume_token(CLOSE_PAR);
      jj_consume_token(COLON);
      value = ObjectFieldValue();
obj.add(new JsonQueryKeyFieldConstruction(key, value));
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public JsonQuery ObjectFieldName() throws ParseException {Token token;
        JsonQuery expr;
        String keywordAsString;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OP_AND:
    case OP_OR:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case KEYWORD_IF:
    case KEYWORD_THEN:
    case KEYWORD_ELIF:
    case KEYWORD_ELSE:
    case KEYWORD_END:
    case KEYWORD_AS:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_CATCH:
    case KEYWORD_LABEL:
    case KEYWORD_IMPORT:
    case KEYWORD_INCLUDE:
    case KEYWORD_MODULE:{
      keywordAsString = KeywordAsString();
expr = new StringLiteral(keywordAsString);
      break;
      }
    case ATSIGN:
    case QUOTE:{
      expr = StringInterpolation();
      break;
      }
    case IDENTIFIER:{
      token = jj_consume_token(IDENTIFIER);
expr = new StringLiteral(token.image);
      break;
      }
    case OPEN_PAR:{
      jj_consume_token(OPEN_PAR);
      expr = JsonQuery();
      jj_consume_token(CLOSE_PAR);
      break;
      }
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery ObjectFieldValue() throws ParseException {JsonQuery expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OPEN_PAR:{
      jj_consume_token(OPEN_PAR);
      expr = JsonQuery();
      jj_consume_token(CLOSE_PAR);
      break;
      }
    case MINUS:
    case DOT:
    case RECURSION:
    case OPEN_BRACKET:
    case DOLLAR:
    case ATSIGN:
    case OPEN_BRACE:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case INTEGER_LITERAL:
    case FLOAT_LITERAL:
    case QUOTE:
    case KEYWORD_IF:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case IDENTIFIER:{
      expr = JsonQueryWithoutComma();
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery ArrayConstruction() throws ParseException {JsonQuery tmp = null;
    jj_consume_token(OPEN_BRACKET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:
    case OPEN_PAR:
    case DOT:
    case RECURSION:
    case OPEN_BRACKET:
    case DOLLAR:
    case ATSIGN:
    case OPEN_BRACE:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case INTEGER_LITERAL:
    case FLOAT_LITERAL:
    case QUOTE:
    case KEYWORD_IF:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case IDENTIFIER:{
      tmp = JsonQuery();
      break;
      }
    default:
      jj_la1[30] = jj_gen;
      ;
    }
    jj_consume_token(CLOSE_BRACKET);
if (tmp == null)
                        {if ("" != null) return new ArrayConstruction();}
                {if ("" != null) return new ArrayConstruction(tmp);}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery ValueLiteral() throws ParseException {Token token;
        String text;
        JsonQuery tmp;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER_LITERAL:{
      token = jj_consume_token(INTEGER_LITERAL);
tmp = new LongLiteral(Long.parseLong(token.image));
      break;
      }
    case FLOAT_LITERAL:{
      token = jj_consume_token(FLOAT_LITERAL);
tmp = new DoubleLiteral(Double.parseDouble(token.image));
      break;
      }
    case NULL_LITERAL:{
      jj_consume_token(NULL_LITERAL);
tmp = new NullLiteral();
      break;
      }
    case BOOLEAN_LITERAL_TRUE:{
      jj_consume_token(BOOLEAN_LITERAL_TRUE);
tmp = new BooleanLiteral(true);
      break;
      }
    case BOOLEAN_LITERAL_FALSE:{
      jj_consume_token(BOOLEAN_LITERAL_FALSE);
tmp = new BooleanLiteral(false);
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return tmp;}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery FunctionCall() throws ParseException {JsonQuery tmp;
        final Token fname;
        final List<JsonQuery> fargs = new ArrayList<JsonQuery>();
    fname = jj_consume_token(IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OPEN_PAR:{
      jj_consume_token(OPEN_PAR);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MINUS:
      case OPEN_PAR:
      case DOT:
      case RECURSION:
      case OPEN_BRACKET:
      case DOLLAR:
      case ATSIGN:
      case OPEN_BRACE:
      case BOOLEAN_LITERAL_TRUE:
      case BOOLEAN_LITERAL_FALSE:
      case NULL_LITERAL:
      case INTEGER_LITERAL:
      case FLOAT_LITERAL:
      case QUOTE:
      case KEYWORD_IF:
      case KEYWORD_DEF:
      case KEYWORD_REDUCE:
      case KEYWORD_FOREACH:
      case KEYWORD_TRY:
      case IDENTIFIER:{
        tmp = JsonQuery();
fargs.add(tmp);
        label_9:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case SEMICOLON:{
            ;
            break;
            }
          default:
            jj_la1[32] = jj_gen;
            break label_9;
          }
          jj_consume_token(SEMICOLON);
          tmp = JsonQuery();
fargs.add(tmp);
        }
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        ;
      }
      jj_consume_token(CLOSE_PAR);
      break;
      }
    default:
      jj_la1[34] = jj_gen;
      ;
    }
{if ("" != null) return new FunctionCall(fname.image, fargs);}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery FieldAccessor(JsonQuery obj) throws ParseException {
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        jj_consume_token(DOT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IDENTIFIER_AFTER_DOT:{
          obj = IdentifierFieldAccessor(obj);
          break;
          }
        case ATSIGN:
        case QUOTE:{
          obj = StringFieldAccessor(obj);
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case OPEN_BRACKET:{
        obj = BracketFieldAccessor(obj);
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:
      case OPEN_BRACKET:{
        ;
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        break label_10;
      }
    }
{if ("" != null) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery ThisObjectAccess() throws ParseException {Token identifier;
        boolean permissive;
        JsonQuery tmp = new ThisObject();
    jj_consume_token(DOT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENTIFIER_AFTER_DOT:
    case OPEN_BRACKET:
    case ATSIGN:
    case QUOTE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENTIFIER_AFTER_DOT:{
        tmp = IdentifierFieldAccessor(tmp);
        break;
        }
      case ATSIGN:
      case QUOTE:{
        tmp = StringFieldAccessor(tmp);
        break;
        }
      case OPEN_BRACKET:{
        tmp = BracketFieldAccessor(tmp);
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:
      case OPEN_BRACKET:{
        tmp = FieldAccessor(tmp);
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      ;
    }
{if ("" != null) return tmp;}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery IdentifierFieldAccessor(JsonQuery obj) throws ParseException {Token identifier;
        boolean permissive = false;
    identifier = jj_consume_token(IDENTIFIER_AFTER_DOT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case QUESTION:{
      jj_consume_token(QUESTION);
permissive = true;
      break;
      }
    default:
      jj_la1[41] = jj_gen;
      ;
    }
{if ("" != null) return new IdentifierFieldAccess(obj, identifier.image, permissive);}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery StringFieldAccessor(JsonQuery obj) throws ParseException {JsonQuery fieldName;
        boolean permissive = false;
    fieldName = StringInterpolation();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case QUESTION:{
      jj_consume_token(QUESTION);
permissive = true;
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      ;
    }
{if ("" != null) return new StringFieldAccess(obj, fieldName, permissive);}
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery BracketFieldAccessor(JsonQuery obj) throws ParseException {JsonQuery begin = null, end = null;
        boolean rangeAccess = true;
        boolean permissive = false;
    jj_consume_token(OPEN_BRACKET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:
    case OPEN_PAR:
    case DOT:
    case RECURSION:
    case OPEN_BRACKET:
    case DOLLAR:
    case ATSIGN:
    case OPEN_BRACE:
    case COLON:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case INTEGER_LITERAL:
    case FLOAT_LITERAL:
    case QUOTE:
    case KEYWORD_IF:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MINUS:
      case OPEN_PAR:
      case DOT:
      case RECURSION:
      case OPEN_BRACKET:
      case DOLLAR:
      case ATSIGN:
      case OPEN_BRACE:
      case BOOLEAN_LITERAL_TRUE:
      case BOOLEAN_LITERAL_FALSE:
      case NULL_LITERAL:
      case INTEGER_LITERAL:
      case FLOAT_LITERAL:
      case QUOTE:
      case KEYWORD_IF:
      case KEYWORD_DEF:
      case KEYWORD_REDUCE:
      case KEYWORD_FOREACH:
      case KEYWORD_TRY:
      case IDENTIFIER:{
        begin = JsonQuery();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COLON:{
          jj_consume_token(COLON);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case MINUS:
          case OPEN_PAR:
          case DOT:
          case RECURSION:
          case OPEN_BRACKET:
          case DOLLAR:
          case ATSIGN:
          case OPEN_BRACE:
          case BOOLEAN_LITERAL_TRUE:
          case BOOLEAN_LITERAL_FALSE:
          case NULL_LITERAL:
          case INTEGER_LITERAL:
          case FLOAT_LITERAL:
          case QUOTE:
          case KEYWORD_IF:
          case KEYWORD_DEF:
          case KEYWORD_REDUCE:
          case KEYWORD_FOREACH:
          case KEYWORD_TRY:
          case IDENTIFIER:{
            end = JsonQuery();
            break;
            }
          default:
            jj_la1[43] = jj_gen;

          }
          break;
          }
        default:
          jj_la1[44] = jj_gen;
rangeAccess = false;
        }
        break;
        }
      case COLON:{
        jj_consume_token(COLON);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case MINUS:
        case OPEN_PAR:
        case DOT:
        case RECURSION:
        case OPEN_BRACKET:
        case DOLLAR:
        case ATSIGN:
        case OPEN_BRACE:
        case BOOLEAN_LITERAL_TRUE:
        case BOOLEAN_LITERAL_FALSE:
        case NULL_LITERAL:
        case INTEGER_LITERAL:
        case FLOAT_LITERAL:
        case QUOTE:
        case KEYWORD_IF:
        case KEYWORD_DEF:
        case KEYWORD_REDUCE:
        case KEYWORD_FOREACH:
        case KEYWORD_TRY:
        case IDENTIFIER:{
          end = JsonQuery();
          break;
          }
        default:
          jj_la1[45] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[47] = jj_gen;
      ;
    }
    jj_consume_token(CLOSE_BRACKET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case QUESTION:{
      jj_consume_token(QUESTION);
permissive = true;
      break;
      }
    default:
      jj_la1[48] = jj_gen;
      ;
    }
if (rangeAccess) {
                        if (begin == null && end == null)
                                {if ("" != null) return new BracketExtractFieldAccess(obj, permissive);}
                        {if ("" != null) return new BracketFieldAccess(obj, begin, end, permissive);}
                } else {
                        {if ("" != null) return new BracketFieldAccess(obj, begin, permissive);}
                }
    throw new Error("Missing return statement in function");
  }

  final public JsonQuery StringInterpolation() throws ParseException {Token t;
        final StringBuilder builder = new StringBuilder();
        final List<Pair<Integer, JsonQuery>> interpolations = new ArrayList<Pair<Integer, JsonQuery>>();
        JsonQuery tmp;
        JsonQuery formatter = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ATSIGN:{
      formatter = FormattingFilter();
      break;
      }
    default:
      jj_la1[49] = jj_gen;
      ;
    }
    jj_consume_token(QUOTE);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case VISIBLE_CHAR:
      case ESCAPE_CHAR:
      case OPEN_INTERP:
      case CODEPOINT_CHAR:{
        ;
        break;
        }
      default:
        jj_la1[50] = jj_gen;
        break label_11;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case VISIBLE_CHAR:{
        t = jj_consume_token(VISIBLE_CHAR);
builder.append(t.image);
        break;
        }
      case ESCAPE_CHAR:{
        t = jj_consume_token(ESCAPE_CHAR);
if (t.image.charAt(0) != '\\')
                                {if (true) throw new IllegalStateException("???");}
                        final char c = t.image.charAt(1);
                        switch (c)
                        {
                                case '\"': builder.append('\"'); break;
                                case '\\': builder.append('\\'); break;
                                case 'b': builder.append((char) 0x08); break;
                                case 'f': builder.append((char) 0x0c); break;
                                case 'r': builder.append((char) 0x0d); break;
                                case 't': builder.append((char) 0x09); break;
                                case 'n': builder.append((char) 0x0a); break;
                                case '/': builder.append('/'); break;
                                default: {
                                        {if (true) throw new IllegalStateException("Unexpected escape char: " + c);}
                                }
                        }
        break;
        }
      case CODEPOINT_CHAR:{
        t = jj_consume_token(CODEPOINT_CHAR);
if (t.image.charAt(0) != '\\' || t.image.charAt(1) != 'u')
                                {if (true) throw new IllegalStateException("???");}
                        builder.appendCodePoint(Integer.parseInt(t.image.substring(2), 16));
        break;
        }
      case OPEN_INTERP:{
        jj_consume_token(OPEN_INTERP);
        tmp = JsonQuery();
        jj_consume_token(CLOSE_PAR);
interpolations.add(Pair.of(builder.length(), tmp));
        break;
        }
      default:
        jj_la1[51] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(ENDQUOTE);
{if ("" != null) return new StringInterpolation(builder.toString(), interpolations, formatter);}
    throw new Error("Missing return statement in function");
  }

  final public PatternMatcher Matcher() throws ParseException {PatternMatcher matcher;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOLLAR:{
      matcher = ValueMatcher();
      break;
      }
    case OPEN_BRACKET:{
      matcher = ArrayMatcher();
      break;
      }
    case OPEN_BRACE:{
      matcher = ObjectMatcher();
      break;
      }
    default:
      jj_la1[52] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return matcher;}
    throw new Error("Missing return statement in function");
  }

  final public PatternMatcher ArrayMatcher() throws ParseException {PatternMatcher matcher;
        final List<PatternMatcher> matchers = new ArrayList<PatternMatcher>();
    jj_consume_token(OPEN_BRACKET);
    matcher = Matcher();
matchers.add(matcher);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[53] = jj_gen;
        break label_12;
      }
      jj_consume_token(COMMA);
      matcher = Matcher();
matchers.add(matcher);
    }
    jj_consume_token(CLOSE_BRACKET);
{if ("" != null) return new ArrayMatcher(matchers);}
    throw new Error("Missing return statement in function");
  }

  final public PatternMatcher ObjectMatcher() throws ParseException {JsonQuery name;
        PatternMatcher matcher;
        final List<Pair<JsonQuery, PatternMatcher>> matchers = new ArrayList<Pair<JsonQuery, PatternMatcher>>();
    jj_consume_token(OPEN_BRACE);
    name = ObjectFieldName();
    jj_consume_token(COLON);
    matcher = Matcher();
matchers.add(Pair.of(name, matcher));
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[54] = jj_gen;
        break label_13;
      }
      jj_consume_token(COMMA);
      name = ObjectFieldName();
      jj_consume_token(COLON);
      matcher = Matcher();
matchers.add(Pair.of(name, matcher));
    }
    jj_consume_token(CLOSE_BRACE);
{if ("" != null) return new ObjectMatcher(matchers);}
    throw new Error("Missing return statement in function");
  }

  final public PatternMatcher ValueMatcher() throws ParseException {Token token;
    jj_consume_token(DOLLAR);
    token = jj_consume_token(IDENTIFIER);
{if ("" != null) return new ValueMatcher(token.image);}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_3R_50()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_28()
 {
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3R_27()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_22()
 {
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3R_26()
 {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3R_48()
 {
    if (jj_scan_token(KEYWORD_FOREACH)) return true;
    return false;
  }

  private boolean jj_3R_19()
 {
    if (jj_scan_token(ESCAPE_CHAR)) return true;
    return false;
  }

  private boolean jj_3R_16()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_18()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_18()
 {
    if (jj_scan_token(VISIBLE_CHAR)) return true;
    return false;
  }

  private boolean jj_3R_25()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_26()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_51()
 {
    if (jj_scan_token(OPEN_BRACKET)) return true;
    return false;
  }

  private boolean jj_3R_15()
 {
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_52()
 {
    if (jj_scan_token(OPEN_BRACE)) return true;
    return false;
  }

  private boolean jj_3R_24()
 {
    if (jj_3R_25()) return true;
    return false;
  }

  private boolean jj_3R_49()
 {
    if (jj_scan_token(KEYWORD_TRY)) return true;
    return false;
  }

  private boolean jj_3R_38()
 {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_14()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_15()) jj_scanpos = xsp;
    if (jj_scan_token(QUOTE)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_16()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ENDQUOTE)) return true;
    return false;
  }

  private boolean jj_3R_17()
 {
    if (jj_scan_token(ATSIGN)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_23()
 {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_47()
 {
    if (jj_scan_token(RECURSION)) return true;
    return false;
  }

  private boolean jj_3R_45()
 {
    if (jj_scan_token(KEYWORD_IF)) return true;
    return false;
  }

  private boolean jj_3R_36()
 {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_35()
 {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_37()
 {
    if (jj_scan_token(KEYWORD_DEF)) return true;
    return false;
  }

  private boolean jj_3R_34()
 {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_33()
 {
    if (jj_3R_46()) return true;
    return false;
  }

  private boolean jj_3R_32()
 {
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_31()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_39()
 {
    if (jj_scan_token(DOLLAR)) return true;
    return false;
  }

  private boolean jj_3R_53()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_44()
 {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_58()
 {
    if (jj_scan_token(BOOLEAN_LITERAL_FALSE)) return true;
    return false;
  }

  private boolean jj_3R_30()
 {
    if (jj_scan_token(OPEN_PAR)) return true;
    return false;
  }

  private boolean jj_3R_43()
 {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_57()
 {
    if (jj_scan_token(BOOLEAN_LITERAL_TRUE)) return true;
    return false;
  }

  private boolean jj_3R_42()
 {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_41()
 {
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_21()
 {
    if (jj_scan_token(OPEN_INTERP)) return true;
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3R_56()
 {
    if (jj_scan_token(NULL_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_55()
 {
    if (jj_scan_token(FLOAT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_46()
 {
    if (jj_scan_token(KEYWORD_REDUCE)) return true;
    return false;
  }

  private boolean jj_3R_40()
 {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_54()
 {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_20()
 {
    if (jj_scan_token(CODEPOINT_CHAR)) return true;
    return false;
  }

  private boolean jj_3R_29()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3_1()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  /** Generated Token Manager. */
  public JsonQueryParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[55];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x18,0x18,0x0,0x0,0x0,0x0,0x0,0x1fffff8,0x1fffff8,0x8000000,0x2000000,0x0,0x0,0x0,0x0,0x10000000,0x10000000,0x0,0x92002000,0x0,0x8000000,0x10000000,0x0,0x0,0x2000018,0x0,0x0,0x2000018,0x2000018,0x92002000,0x92002000,0x0,0x8000000,0x92002000,0x2000000,0x20000000,0x10000000,0x10000000,0x20000000,0x10000000,0x20000000,0x0,0x0,0x92002000,0x0,0x92002000,0x92002000,0x92002000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0xff801c00,0xff801c00,0x10000010,0x10000000,0x10000010,0x10000000,0x200,0x0,0x0,0x0,0x0,0x8,0x20000000,0x7c00,0x61,0x1,0x1,0x4,0xc0817c69,0x0,0x0,0x1,0x2000000,0x200,0xff811c28,0x100,0x100,0xff811c28,0xff811c20,0xe0817c69,0xe0817c69,0x7c00,0x0,0xe0817c69,0x0,0x10020,0x1,0x1,0x10021,0x1,0x10021,0x4,0x4,0xe0817c69,0x100,0xe0817c69,0xe0817d69,0xe0817d69,0x4,0x20,0x740000,0x740000,0x49,0x200,0x200,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x3f,0x7f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x41,0x2,0x0,0x0,0x0,0x0,0x7f,0x0,0x0,0x7f,0x7f,0x41,0x41,0x0,0x0,0x41,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x41,0x0,0x41,0x41,0x41,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[1];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public JsonQueryParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public JsonQueryParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new JsonQueryParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public JsonQueryParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new JsonQueryParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
      jj_input_stream = new SimpleCharStream(stream, 1, 1);
   } else {
      jj_input_stream.ReInit(stream, 1, 1);
   }
   if (token_source == null) {
      token_source = new JsonQueryParserTokenManager(jj_input_stream);
   }

    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public JsonQueryParser(JsonQueryParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(JsonQueryParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) {
       return;
    }

    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];

      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }

      for (int[] oldentry : jj_expentries) {
        if (oldentry.length == jj_expentry.length) {
          boolean isMatched = true;

          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              isMatched = false;
              break;
            }

          }
          if (isMatched) {
            jj_expentries.add(jj_expentry);
            break;
          }
        }
      }

      if (pos != 0) {
        jj_lasttokens[(jj_endpos = pos) - 1] = kind;
      }
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[73];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 55; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 73; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 1; i++) {
      try {
        JJCalls p = jj_2_rtns[i];

        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
            }
          }
          p = p.next;
        } while (p != null);

        } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }

    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

        }
