/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.auto.service.AutoService;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"to_entries/0"})
@AutoService(value={Function.class})
public class ToEntriesFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        ArrayNode out = scope.getObjectMapper().createArrayNode();
        if (in.isObject()) {
            Iterator iter = in.fields();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                ObjectNode entryNode = scope.getObjectMapper().createObjectNode();
                entryNode.set("key", (JsonNode)new TextNode((String)entry.getKey()));
                entryNode.set("value", (JsonNode)entry.getValue());
                out.add((JsonNode)entryNode);
            }
        } else if (in.isArray()) {
            Iterator iter = in.iterator();
            int i = 0;
            while (iter.hasNext()) {
                JsonNode value = (JsonNode)iter.next();
                ObjectNode entryNode = scope.getObjectMapper().createObjectNode();
                entryNode.set("key", (JsonNode)IntNode.valueOf((int)i));
                entryNode.set("value", value);
                out.add((JsonNode)entryNode);
                ++i;
            }
        } else {
            throw new JsonQueryTypeException("%s has no keys", in);
        }
        output.emit((JsonNode)out, null);
    }
}

