/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree.matcher.matchers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.List;
import java.util.Stack;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.misc.Functional;
import net.thisptr.jackson.jq.internal.misc.Pair;
import net.thisptr.jackson.jq.internal.tree.matcher.PatternMatcher;
import net.thisptr.jackson.jq.path.ObjectFieldPath;
import net.thisptr.jackson.jq.path.Path;

public class ObjectMatcher
implements PatternMatcher {
    private List<Pair<Expression, PatternMatcher>> matchers;

    public ObjectMatcher(List<Pair<Expression, PatternMatcher>> matchers) {
        this.matchers = matchers;
    }

    private void recursive(Scope scope, JsonNode in, Functional.Consumer<List<Pair<String, JsonNode>>> out, Stack<Pair<String, JsonNode>> accumulate, int index) throws JsonQueryException {
        if (index >= this.matchers.size()) {
            out.accept(accumulate);
            return;
        }
        Pair<Expression, PatternMatcher> kvexpr = this.matchers.get(index);
        Expression keyexpr = (Expression)kvexpr._1;
        PatternMatcher matcher = (PatternMatcher)kvexpr._2;
        keyexpr.apply(scope, in, key -> {
            if (!key.isTextual()) {
                throw new JsonQueryTypeException("Cannot index %s with %s", in.getNodeType(), key.getNodeType());
            }
            JsonNode value = in.get(key.asText());
            int size = accumulate.size();
            matcher.match(scope, (JsonNode)(value != null ? value : NullNode.getInstance()), match -> this.recursive(scope, in, out, accumulate, index + 1), accumulate);
            accumulate.setSize(size);
        });
    }

    private void recursiveWithPath(Scope scope, JsonNode in, Path inpath, PatternMatcher.MatchOutput output, Stack<PatternMatcher.MatchWithPath> accumulate, int index) throws JsonQueryException {
        if (index >= this.matchers.size()) {
            output.emit(accumulate);
            return;
        }
        Pair<Expression, PatternMatcher> kvexpr = this.matchers.get(index);
        Expression keyexpr = (Expression)kvexpr._1;
        PatternMatcher matcher = (PatternMatcher)kvexpr._2;
        keyexpr.apply(scope, in, key -> {
            if (!key.isTextual()) {
                throw new JsonQueryTypeException("Cannot index %s with %s", in.getNodeType(), key.getNodeType());
            }
            JsonNode value = in.get(key.asText());
            ObjectFieldPath valuepath = ObjectFieldPath.chainIfNotNull(inpath, key.asText());
            int size = accumulate.size();
            matcher.matchWithPath(scope, (JsonNode)(value != null ? value : NullNode.getInstance()), valuepath, match -> this.recursiveWithPath(scope, in, inpath, output, accumulate, index + 1), accumulate);
            accumulate.setSize(size);
        });
    }

    @Override
    public void match(Scope scope, JsonNode in, Functional.Consumer<List<Pair<String, JsonNode>>> out, Stack<Pair<String, JsonNode>> accumulate) throws JsonQueryException {
        if (!in.isObject() && !in.isNull()) {
            throw new JsonQueryTypeException("Cannot index %s with string", in.getNodeType());
        }
        this.recursive(scope, in, out, accumulate, 0);
    }

    @Override
    public void matchWithPath(Scope scope, JsonNode in, Path path, PatternMatcher.MatchOutput output, Stack<PatternMatcher.MatchWithPath> accumulate) throws JsonQueryException {
        if (!in.isObject() && !in.isNull()) {
            throw new JsonQueryTypeException("Cannot index %s with string", in.getNodeType());
        }
        this.recursiveWithPath(scope, in, path, output, accumulate, 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        String sep = "";
        for (Pair<Expression, PatternMatcher> entry : this.matchers) {
            sb.append(sep);
            sb.append(entry._1);
            sb.append(": ");
            sb.append(entry._2);
            sep = ", ";
        }
        sb.append("}");
        return sb.toString();
    }
}

