/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.List;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.misc.PathUtils;
import net.thisptr.jackson.jq.path.ArrayIndexPath;
import net.thisptr.jackson.jq.path.ArrayRangeIndexPath;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"delpaths/1"})
@AutoService(value={Function.class})
public class DelPathsFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        args.get(0).apply(scope, in, paths -> {
            if (!paths.isArray()) {
                throw new JsonQueryException("Paths must be specified as an array");
            }
            ArrayList<JsonNode> sortedPaths = new ArrayList<JsonNode>(paths.size());
            for (JsonNode path : paths) {
                if (!path.isArray()) {
                    throw new JsonQueryException("Path must be specified as array, not " + path.getNodeType().toString().toLowerCase());
                }
                sortedPaths.add(path);
            }
            sortedPaths.sort(JsonNodeComparator.getInstance());
            JsonNode out = in;
            for (int i = sortedPaths.size() - 1; i >= 0; --i) {
                Path path = PathUtils.toPath((JsonNode)sortedPaths.get(i));
                out = path.mutate(out, oldval -> {
                    if (path instanceof ArrayRangeIndexPath && oldval.isArray()) {
                        ArrayNode newval = scope.getObjectMapper().createArrayNode();
                        for (int j = 0; j < oldval.size(); ++j) {
                            newval.add((JsonNode)MissingNode.getInstance());
                        }
                        return newval;
                    }
                    if (path instanceof ArrayIndexPath && ((ArrayIndexPath)path).index.asDouble() < 0.0 && version.compareTo(Versions.JQ_1_5) <= 0) {
                        return oldval;
                    }
                    return MissingNode.getInstance();
                }, false);
            }
            output.emit(JsonNodeUtils.filter(out, val -> !val.isMissingNode()), null);
        });
    }
}

