/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.List;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.misc.Pair;
import net.thisptr.jackson.jq.internal.misc.Preconditions;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"sort_by/1"})
@AutoService(value={Function.class})
public class SortByFunction
implements Function {
    private static final JsonNodeComparator comparator = JsonNodeComparator.getInstance();

    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode items, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        Preconditions.checkInputType("sort_by", items, JsonNodeType.ARRAY);
        ArrayList zipped = new ArrayList(items.size());
        for (JsonNode item : items) {
            ArrayNode value = scope.getObjectMapper().createArrayNode();
            args.get(0).apply(scope, item, arg_0 -> ((ArrayNode)value).add(arg_0));
            zipped.add(Pair.of(item, value));
        }
        zipped.sort((o1, o2) -> comparator.compare((JsonNode)o1._2, (JsonNode)o2._2));
        output.emit((JsonNode)JsonNodeUtils.asArrayNode(scope.getObjectMapper(), Pair._1(zipped)), null);
    }
}

