/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.internal.utils.ExpressionUtils;

public class ImportStatement {
    public final String path;
    public final boolean dollarImport;
    public final String name;
    public final JsonNode metadata;

    public ImportStatement(String path, boolean dollarImport, String name, Expression metadataExpr) {
        this.path = path;
        this.dollarImport = dollarImport;
        this.name = name;
        if (metadataExpr != null) {
            this.metadata = ExpressionUtils.evaluateLiteralExpression(metadataExpr);
            if (this.metadata == null) {
                throw new IllegalArgumentException("Module metadata must be constant");
            }
            if (!this.metadata.isObject()) {
                throw new IllegalArgumentException("Module metadata must be an object");
            }
        } else {
            this.metadata = null;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("import ");
        s.append(new TextNode(this.path).toString());
        s.append(" as ");
        if (this.dollarImport) {
            s.append('$');
        }
        s.append(this.name);
        if (this.metadata != null) {
            s.append(' ');
            s.append(this.metadata);
        }
        return s.toString();
    }
}

