/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.tree.FieldConstruction;

public class StringKeyFieldConstruction
implements FieldConstruction {
    public final Expression key;
    public final Expression value;

    public StringKeyFieldConstruction(Expression key, Expression value) {
        this.key = key;
        this.value = value;
    }

    public StringKeyFieldConstruction(Expression key) {
        this(key, null);
    }

    @Override
    public void evaluate(Scope scope, JsonNode in, FieldConstruction.FieldConsumer consumer) throws JsonQueryException {
        this.key.apply(scope, in, k -> {
            if (!k.isTextual()) {
                throw new JsonQueryException("key must evaluate to string");
            }
            if (this.value == null) {
                consumer.accept(k.asText(), JsonNodeUtils.nullToNullNode(in.get(k.asText())));
            } else {
                this.value.apply(scope, in, v -> consumer.accept(k.asText(), v));
            }
        });
    }

    public String toString() {
        if (this.value == null) {
            return this.key.toString();
        }
        return this.key.toString() + ": " + this.value.toString();
    }
}

