/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.internal.tree.ArrayConstruction;
import net.thisptr.jackson.jq.internal.tree.FieldConstruction;
import net.thisptr.jackson.jq.internal.tree.IdentifierKeyFieldConstruction;
import net.thisptr.jackson.jq.internal.tree.ObjectConstruction;
import net.thisptr.jackson.jq.internal.tree.StringKeyFieldConstruction;
import net.thisptr.jackson.jq.internal.tree.Tuple;
import net.thisptr.jackson.jq.internal.tree.literal.StringLiteral;
import net.thisptr.jackson.jq.internal.tree.literal.ValueLiteral;

public class ExpressionUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static JsonNode evaluateLiteralExpression(Expression expr) {
        if (expr instanceof ObjectConstruction) {
            ObjectNode obj = MAPPER.createObjectNode();
            for (FieldConstruction field : ((ObjectConstruction)expr).fields) {
                JsonNode v;
                String k;
                FieldConstruction f;
                if (field instanceof IdentifierKeyFieldConstruction) {
                    f = (IdentifierKeyFieldConstruction)field;
                    k = f.key;
                    if (f.value == null) {
                        return null;
                    }
                    v = ExpressionUtils.evaluateLiteralExpression(f.value);
                    if (v == null) {
                        return null;
                    }
                    obj.set(k, v);
                    continue;
                }
                if (field instanceof StringKeyFieldConstruction) {
                    f = (StringKeyFieldConstruction)field;
                    if (!(((StringKeyFieldConstruction)f).key instanceof StringLiteral)) {
                        return null;
                    }
                    k = ((StringLiteral)((StringKeyFieldConstruction)f).key).value().asText();
                    v = ExpressionUtils.evaluateLiteralExpression(((StringKeyFieldConstruction)f).value);
                    if (v == null) {
                        return null;
                    }
                    obj.set(k, v);
                    continue;
                }
                return null;
            }
            return obj;
        }
        if (expr instanceof ArrayConstruction) {
            ArrayNode array = MAPPER.createArrayNode();
            Expression tuple = ((ArrayConstruction)expr).q;
            if (tuple == null) {
                return array;
            }
            if (tuple instanceof Tuple) {
                List<Expression> values = ((Tuple)tuple).qs;
                for (Expression valueExpr : values) {
                    JsonNode value = ExpressionUtils.evaluateLiteralExpression(valueExpr);
                    if (value == null) {
                        return null;
                    }
                    array.add(value);
                }
            } else {
                array.add(ExpressionUtils.evaluateLiteralExpression(tuple));
            }
            return array;
        }
        if (expr instanceof ValueLiteral) {
            return ((ValueLiteral)expr).value();
        }
        return null;
    }
}

