/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.auto.service.AutoService;
import java.util.List;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.Preconditions;
import net.thisptr.jackson.jq.path.Path;

public abstract class MathFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        Preconditions.checkInputType("mathfunc", in, JsonNodeType.NUMBER);
        output.emit((JsonNode)new DoubleNode(this.f(in.asDouble())), null);
    }

    protected abstract double f(double var1);

    @BuiltinFunction(value={"exp10/0"}, version="[1.6, )")
    @AutoService(value={Function.class})
    public static class Exp10Function
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.pow(10.0, v);
        }
    }

    @BuiltinFunction(value={"exp2/0"})
    @AutoService(value={Function.class})
    public static class Exp2Function
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.pow(2.0, v);
        }
    }

    @BuiltinFunction(value={"expm1/0"}, version="[1.6, )")
    @AutoService(value={Function.class})
    public static class Expm1Function
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.expm1(v);
        }
    }

    @BuiltinFunction(value={"exp/0"})
    @AutoService(value={Function.class})
    public static class ExpFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.exp(v);
        }
    }

    @BuiltinFunction(value={"log1p/0"}, version="[1.6, )")
    @AutoService(value={Function.class})
    public static class Log1pFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.log1p(v);
        }
    }

    @BuiltinFunction(value={"log10/0"})
    @AutoService(value={Function.class})
    public static class Log10Function
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.log10(v);
        }
    }

    @BuiltinFunction(value={"log/0"})
    @AutoService(value={Function.class})
    public static class LogFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.log(v);
        }
    }

    @BuiltinFunction(value={"log2/0"})
    @AutoService(value={Function.class})
    public static class Log2Function
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.log10(v) / Math.log10(2.0);
        }
    }

    @BuiltinFunction(value={"sqrt/0"})
    @AutoService(value={Function.class})
    public static class SqrtFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.sqrt(v);
        }
    }

    @BuiltinFunction(value={"cbrt/0"})
    @AutoService(value={Function.class})
    public static class CbrtFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.cbrt(v);
        }
    }

    @BuiltinFunction(value={"sinh/0"})
    @AutoService(value={Function.class})
    public static class SinhFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.sinh(v);
        }
    }

    @BuiltinFunction(value={"sin/0"})
    @AutoService(value={Function.class})
    public static class SinFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.sin(v);
        }
    }

    @BuiltinFunction(value={"asin/0"})
    @AutoService(value={Function.class})
    public static class AsinFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.asin(v);
        }
    }

    @BuiltinFunction(value={"floor/0"})
    @AutoService(value={Function.class})
    public static class FloorFunction
    extends MathFunction {
        @Override
        protected double f(double f) {
            return Math.floor(f);
        }
    }

    @BuiltinFunction(value={"cosh/0"})
    @AutoService(value={Function.class})
    public static class CoshFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.cosh(v);
        }
    }

    @BuiltinFunction(value={"cos/0"})
    @AutoService(value={Function.class})
    public static class CosFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.cos(v);
        }
    }

    @BuiltinFunction(value={"acos/0"})
    @AutoService(value={Function.class})
    public static class AcosFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.acos(v);
        }
    }

    @BuiltinFunction(value={"tanh/0"})
    @AutoService(value={Function.class})
    public static class TanhFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.tanh(v);
        }
    }

    @BuiltinFunction(value={"tan/0"})
    @AutoService(value={Function.class})
    public static class TanFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.tan(v);
        }
    }

    @BuiltinFunction(value={"atan/0"})
    @AutoService(value={Function.class})
    public static class AtanFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.atan(v);
        }
    }
}

